/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DispatcherServiceImpl
implements DispatcherService {
    private final DispatcherDao dispatcherDao;
    private final DspService dspService;

    public DispatcherServiceImpl(DispatcherDao dispatcherDao, DspService dspService) {
        this.dispatcherDao = dispatcherDao;
        this.dspService = dspService;
    }

    @Override
    public Map<Integer, Collection<Dsp>> getPriority(String positionId) {
        Collection<Dispatcher> dispatchers = this.dispatcherDao.get(positionId);
        TreeMap dsps = Maps.newTreeMap();
        if (CollectionUtils.isEmpty(dispatchers)) {
            return dsps;
        }
        for (Dispatcher dispatcher : dispatchers) {
            if (!dispatcher.isOpened()) continue;
            int priority = dispatcher.getPriority();
            Long dspId = dispatcher.getDspId();
            Dsp dsp = this.dspService.get(dspId);
            Collection collection = MapHelper.get(dsps, priority, new ArrayList());
            collection.add(dsp);
        }
        return dsps;
    }

    @Override
    public Collection<Dispatcher> get(String positionId) {
        return this.dispatcherDao.get(positionId);
    }

    @Override
    public Dispatcher getByAppPosId(String appPosId, String dspCode) {
        return this.dispatcherDao.getByAppPosId(appPosId, dspCode);
    }

    @Override
    public Dispatcher get(String positionId, String dspId) {
        return this.dispatcherDao.get(positionId, dspId);
    }
}

