/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.ingetration;

import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.abtest.facade.model.AlgorithmResponse;
import com.bxm.abtest.facade.service.ABtestFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@EnableFeignClients(value={"com.bxm.abtest.facade"})
@Service
public class AbtestServiceIntegration {
    private static final Logger logger = LoggerFactory.getLogger(AbtestServiceIntegration.class);
    @Autowired
    private ABtestFacadeService aBtestFacadeService;

    public String getAlgorithmCode(AlgorithmRequest algorithmRequest) {
        try {
            AlgorithmResponse algorithmResponse = this.aBtestFacadeService.getAlgorithmCode(algorithmRequest);
            if (algorithmResponse != null && !StringUtils.isEmpty((Object)algorithmResponse.getAlgorithmCode())) {
                return algorithmResponse.getAlgorithmCode();
            }
            logger.error(" \u8fd4\u56deAlgorithmCode\u4e3a\u7a7a");
            return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
        }
        catch (Exception e) {
            logger.error(" \u8c03\u7528abtest\u5931\u8d25 {}", (Throwable)e);
            return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
        }
    }
}

