/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxException;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.PriorityBuyers;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidRequestWrapper;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class DefaultBidRequestWrapper
implements BidRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultBidRequestWrapper.class);
    private final PriorityBuyers priorityBuyers;
    private final PositionService positionService;
    private final AdxProperties properties;

    public DefaultBidRequestWrapper(PriorityBuyers priorityBuyers, PositionService positionService, AdxProperties properties) {
        this.priorityBuyers = priorityBuyers;
        this.positionService = positionService;
        this.properties = properties;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MarketOrders packing(BidRequest bidRequest) {
        void var6_9;
        Position position;
        if (null == bidRequest) {
            return null;
        }
        List<Impression> imps = bidRequest.getImps();
        if (CollectionUtils.isEmpty(imps)) {
            return null;
        }
        HashMap positionListMap = Maps.newHashMap();
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (Impression impression : imps) {
            String string = impression.getTag_id();
            if (StringUtils.isBlank((String)string)) continue;
            position = this.positionService.getByPositionId(string);
            if (null != position) {
                positionList.add(position);
            }
            if (null == position || !position.isEnabled()) continue;
            List<List<Buyer>> buyers = this.priorityBuyers.findAsPriority(position);
            this.handleBackupEntrance(bidRequest, buyers);
            positionListMap.put(position, buyers);
        }
        ArrayList requests = Lists.newArrayListWithCapacity((int)this.properties.getMaxCapacityOfBuyers());
        for (Map.Entry entry : positionListMap.entrySet()) {
            position = (Position)entry.getKey();
            List list = (List)entry.getValue();
            int level = list.size();
            if (level == 0) continue;
            for (int i = 0; i < level; ++i) {
                MarketRequest marketRequest;
                List array = (List)list.get(i);
                if (CollectionUtils.isEmpty((Collection)array)) continue;
                MarketRequest marketRequest2 = CollectionUtils.isEmpty((Collection)requests) ? null : (marketRequest = requests.size() > i ? (MarketRequest)requests.get(i) : null);
                if (null == marketRequest) {
                    marketRequest = new MarketRequest(i);
                    requests.add(i, marketRequest);
                }
                marketRequest.addBuyers(array);
                marketRequest.addPosition(position);
            }
        }
        boolean bl = false;
        while (var6_9 < requests.size()) {
            MarketRequest marketRequest = (MarketRequest)requests.get((int)var6_9);
            Set<Buyer> buyers = marketRequest.getBuyers();
            Set<Position> positions = marketRequest.getPositions();
            for (void j = var6_9 + true; j < requests.size(); ++j) {
                MarketRequest low = (MarketRequest)requests.get((int)j);
                Set<Buyer> lowBuyers = low.getBuyers();
                Set<Position> lowPositions = low.getPositions();
                Iterator<Buyer> iterator = lowBuyers.iterator();
                while (iterator.hasNext()) {
                    if (!buyers.contains(iterator.next())) continue;
                    positions.addAll(lowPositions);
                    iterator.remove();
                }
            }
            ++var6_9;
        }
        MarketOrders marketOrders = new MarketOrders(bidRequest, requests, positionList);
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)JsonHelper.convert((Object)marketOrders));
        }
        return marketOrders;
    }

    private void handleBackupEntrance(BidRequest request, List<List<Buyer>> buyers) {
        String entanceName = request.getEntrance_name();
        if (StringUtils.isEmpty((String)entanceName)) {
            return;
        }
        if ("backup".equalsIgnoreCase(entanceName)) {
            buyers.clear();
            ArrayList<Buyer> buyerList = new ArrayList<Buyer>();
            buyers.add(buyerList);
            Map<String, Buyer> allBuyers = this.priorityBuyers.getAllBuyers();
            Buyer buyer = allBuyers.get("backup-dsp");
            if (buyer == null) {
                throw new AdxException("can't find backup-dsp ");
            }
            buyerList.add(buyer);
        }
    }
}

