package com.bxm.adx.common.adapter;

import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @date 2020-09-25
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class AdxContext {

    public static final String CIPHER_TYPE_AES_RESPONSE = "1";

    private Object attachment;
    private String cipherType;
    private String uid;
    private Long configId;

    public boolean isCipherAesForResponse() {
        return StringUtils.equals(CIPHER_TYPE_AES_RESPONSE, cipherType);
    }
}
