package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.domain.DomainService;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.Config;
import com.bxm.adx.common.sell.ssp.resp.VMonitor;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.warcar.utils.StringHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class ConcreteSspResponseBuilder extends SspResponseBuilder {

    private AdxProperties properties;
    private PositionService positionService;
    private MonitorBuilder monitorBuilder;
    private DomainService domainService;

    public ConcreteSspResponseBuilder(AdxProperties properties, PositionService positionService, MonitorBuilder monitorBuilder, DomainService domainService) {
        this.properties = properties;
        this.positionService = positionService;
        this.monitorBuilder = monitorBuilder;
        this.domainService = domainService;
    }

    @Override
    public void buildResult(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;

        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "无";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest, SspResponse sspResponse) {
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        AdxCounterParam param = null;
        if (null != bidRequest) {
            Device device = bidRequest.getDevice();
            if (null != device) {
                String os = null;
                String osStr = device.getOs();
                if (!StringUtils.isEmpty(osStr)) {
                    if ("ios".equalsIgnoreCase(osStr)) {
                        os = "2";
                    }
                    if ("android".equalsIgnoreCase(osStr)) {
                        os = "1";
                    }
                }

                Long configId = AdxContextFactory.get().getConfigId();
                param = AdxCounterParam.builder()
                        .anid(device.getDpid())
                        .anid_md5(device.getDpid_md5())
                        .idfa(device.getIdfa())
                        .idfa_md5(device.getIdfa_md5())
                        .imei(device.getImei())
                        .imei_md5(device.getImei_md5())
                        .oaid(device.getOaid())
                        .mac(device.getMac())
                        .os(os)
                        .ip(device.getIp())
                        .ua(device.getUa())//埋点加密自己做了转码
//                            .ua(URLEncoder.encode(device.getUa(), "UTF-8"))
                        .experimentid(configId == null ? "":configId.toString())
                        .build();
            }
        }
        String url = domainService.replaceCountDomain(bidRequest, properties.getCounterBaseUrl());

        List<com.bxm.adx.common.sell.ssp.resp.Ad> ads = new ArrayList<>(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            for (Bid bid : bids) {

                if (param == null) {
                    param = AdxCounterParam.builder().build();
                }

                param.setBidid(e.getId());
                param.setDspid(seatBid.getDspId().toString());
                param.setCreateid(bid.getCreate_id());
                param.setTagid(bid.getTag_id());
                param.setScene(bid.getScene());
                param.setWin(bid.getPrice_str());
                param.setActid(bid.getAct_id());

                com.bxm.adx.common.sell.ssp.resp.Ad ad = new com.bxm.adx.common.sell.ssp.resp.Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric(8));
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                ad.setExt(bid.getExt());

                Position position = positionService.getByPositionId(ad.getPlace_token());

                if (null != position) {
                    //获取广告位配置
                    Config config = new Config();
                    ad.setConfig(config);
                    config.setBoot_time(position.getBootTime());
                    config.setClick_video_action(position.getClickVideoAction());
                    config.setShow_ad_logo(position.getIsShowAdLogo());
                    config.setShow_endpage(position.getIsShowEndpage());
                    config.setRefreshInterval_time(position.getRefreshIntervalTime());
                    config.setRefresh_model(position.getRefreshModel());
                    config.setOpen_preloading(position.getOpenPreloading() == null ? 0 : position.getOpenPreloading());
                    //从广告位拿到尺寸信息
                    String positionSize = position.getPositionSize();
                    if (StringUtils.isEmpty(positionSize)) {
                        if (log.isDebugEnabled()) {
                            log.debug("positionSize err");
                        }
                    } else {
                        Map<String, Integer> sizeMap = AdxUtils.getPositionSize(positionSize);
                        if (CollectionUtils.isEmpty(sizeMap)) {
                            if (log.isDebugEnabled()) {
                                log.debug("positionSize analysis err");
                            }
                        } else {
                            Integer w = sizeMap.get("w");
                            Integer h = sizeMap.get("h");
                            param.setW(w == null ? "" : w.toString());
                            param.setH(h == null ? "" : h.toString());
                        }
                    }
                    //获取广告位样式模版
                    if (null != position.getInformationFlowTemplate()) {
                        ad.setTemplate(position.getInformationFlowTemplate());
                    }

                    config.setShow_title_bar(bid.getShow_title_bar() == null ? 1 : bid.getShow_title_bar());
                }

                ad.setClick_trackers(monitorBuilder.fillClickMonitor(bid.getClick_monitors(), url, param));

                ad.setImp_trackers(monitorBuilder.fillImpMonitor(bid.getImp_monitors(), url, param));

                ad.setDeeplink_url(bid.getDeep_link_url());
                if (StringUtils.isNotEmpty(bid.getDeep_link_url())) {
                    ad.setDp_tracker(monitorBuilder.fillDpMonitor(bid.getDpMonitor(), url, param));
                }
                //支持deeplink监测和sdk版本控制
                if (!StringHelper.isNewVersion(SdkVersionEnum.SUPPORT_DEEPLINK_310.getVersion(), bidRequest.getSdk_ver())) {
                    if (null != ad.getDp_tracker()) {
                        List<String> dpSuccessUrls = ad.getDp_tracker().getAwk_success_urls();
                        if (!CollectionUtils.isEmpty(dpSuccessUrls)) {
                            List<String> cts = ad.getClick_trackers();
                            if (!CollectionUtils.isEmpty(cts)) {
                                cts.addAll(dpSuccessUrls);
                            } else {
                                cts = dpSuccessUrls;
                            }
                            ad.setClick_trackers(cts);
                        }
                    }
                }
                if (AdxConstants.Action.isAppDownload(ad.getAction())) {
                    ad.setAppTracker(monitorBuilder.fillAppTracker(bid.getApp_monitor(), url, param));
                }
                ad.setTarget_url(bid.getClick_through_url());

                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                com.bxm.adx.common.sell.ssp.resp.Native an = new com.bxm.adx.common.sell.ssp.resp.Native();
                List<com.bxm.adx.common.sell.ssp.resp.Asset> assets = new ArrayList<>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                List<com.bxm.adx.common.sell.response.Asset> snAssets = sn.getAssets();
                for (com.bxm.adx.common.sell.response.Asset sa : snAssets) {
                    com.bxm.adx.common.sell.ssp.resp.Asset asset = new com.bxm.adx.common.sell.ssp.resp.Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    AdxConstants.AssetType assetType = AdxConstants.AssetType.getAssetType(sa.getType());
                    if (assetType == AdxConstants.AssetType.UNKNOW) {
                        if (log.isWarnEnabled()) {
                            log.warn("posId = {}, asset = {}", position.getPositionId(), assetType.name());
                        }
                    }
                    switch (assetType) {
                        case TITLE:
                            com.bxm.adx.common.sell.ssp.resp.Text title = new com.bxm.adx.common.sell.ssp.resp.Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        case CONTENT:
                            com.bxm.adx.common.sell.ssp.resp.Text content = new com.bxm.adx.common.sell.ssp.resp.Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        case BTN_TEXT:
                            com.bxm.adx.common.sell.ssp.resp.Text buttonText = new com.bxm.adx.common.sell.ssp.resp.Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        case ICON:
                            com.bxm.adx.common.sell.ssp.resp.Image image = new com.bxm.adx.common.sell.ssp.resp.Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            image.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(image);
                            break;
                        case LARGE_IMG:
                            com.bxm.adx.common.sell.ssp.resp.Image limg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            limg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(limg);
                            break;
                        case BTN_IMG:
                            com.bxm.adx.common.sell.ssp.resp.Image bimg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            bimg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(bimg);
                            break;
                        case REWARDER_VIDEO:
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            com.bxm.adx.common.sell.response.Video v = sa.getVideo();
                            BeanUtils.copyProperties(v, video);

                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties(v.getV_monitor(), vm);
                            }
                            Integer duration = video.getDuration();
                            if (null != duration) {
                                param.setVi_duration((duration / 1000) + "");
                            }
                            video.setV_monitor(monitorBuilder.fillVMonitor(vm, url, param));
                            asset.setVideo(video);
                            break;
                        default:
                            if (log.isWarnEnabled()) {
                                log.warn("posId = {}, asset = {}", position.getPositionId(), assetType.name());
                            }
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);
                ads.add(ad);
            }
        }
        sspResponse.setAds(ads);
        sspResponse.setResult(AdxConstants.RESULT_OK);
    }
}
