package com.bxm.adx.common.entity;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * Created by Arei on 2020/11/5.
 */
@Builder
@Data
public class AdxCounterParam implements Serializable {
    private String mt;
    private String bidid;
    private String tagid;
    private String createid;
    private String dspid;
    private String ip;
    private String os;
    private String ua;
    private String imei;
    private String imei_md5;
    private String anid;
    private String anid_md5;
    private String oaid;
    private String idfa;
    private String idfa_md5;
    private String win;
    private String mac;
    private String actid;
    private String scene;
    private String timestamp;
    //    private String ext;
    private String w;
    private String h;
    private String vi_duration;
    private String experimentid;

    @Override
    public String toString() {
        return
                "mt=" + (StringUtils.isNotEmpty(mt) ? mt : "") +
                        "&bidid=" + (StringUtils.isNotEmpty(bidid) ? bidid : "") +
                        "&tagid=" + (StringUtils.isNotEmpty(tagid) ? tagid : "") +
                        "&createid=" + (StringUtils.isNotEmpty(createid) ? createid : "") +
                        "&dspid=" + (StringUtils.isNotEmpty(dspid) ? dspid : "") +
                        "&ip=" + (StringUtils.isNotEmpty(ip) ? ip : "") +
                        "&os=" + (StringUtils.isNotEmpty(os) ? os : "") +
                        "&ua=" + (StringUtils.isNotEmpty(ua) ? ua : "") +
                        "&imei=" + (StringUtils.isNotEmpty(imei) ? imei : "") +
                        "&imei_md5=" + (StringUtils.isNotEmpty(imei_md5) ? imei_md5 : "") +
                        "&anid=" + (StringUtils.isNotEmpty(anid) ? anid : "") +
                        "&anid_md5=" + (StringUtils.isNotEmpty(anid_md5) ? anid_md5 : "") +
                        "&oaid=" + (StringUtils.isNotEmpty(oaid) ? oaid : "") +
                        "&idfa=" + (StringUtils.isNotEmpty(idfa) ? idfa : "") +
                        "&idfa_md5=" + (StringUtils.isNotEmpty(idfa_md5) ? idfa_md5 : "") +
                        "&win=" + (StringUtils.isNotEmpty(win) ? win : "") +
                        "&mac=" + (StringUtils.isNotEmpty(mac) ? mac : "") +
                        "&actid=" + (StringUtils.isNotEmpty(actid) ? actid : "") +
                        "&experimentid=" + (StringUtils.isNotEmpty(experimentid) ? experimentid : "") +
                        "&scene=" + (StringUtils.isNotEmpty(scene) ? scene : "") +
                        "&timestamp=" + (StringUtils.isNotEmpty(timestamp) ? timestamp : "");
    }

    public String getClickUnEncodeParam() {
        return "&x_down=__X_DOWN__" +
                "&y_down=__Y_DOWN__" +
                "&x_up=__X_UP__" +
                "&y_up=__Y_UP__" +
                "&reqpw=" + (StringUtils.isNotEmpty(w) ? w : "") +
                "&reqph=" + (StringUtils.isNotEmpty(h) ? h : "") +
                "&actpw=__ACTPW__" +
                "&actph=__ACTPH__";
    }

    public String getVideoUnEncodeParam() {
        return "&vi_duration=" + (StringUtils.isNotEmpty(vi_duration) ? vi_duration : "__VI_DURATION__") +
                "&status=__STATUS__";
    }
}
