package com.bxm.adx.common.ingetration.feign;

import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.abtest.facade.model.AlgorithmResponse;
import com.bxm.abtest.facade.service.ABtestFacadeService;
import com.bxm.adx.common.ingetration.AbtestServiceIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
@EnableFeignClients("com.bxm.abtest.facade")
@Configuration
@Profile("!standalone")
public class FeignAbtestServiceIntegrationImpl implements AbtestServiceIntegration {

    private static final Logger logger = LoggerFactory.getLogger(AbtestServiceIntegration.class);

    @Autowired
    private ABtestFacadeService aBtestFacadeService;

    /**
     * 获取算法code
     *
     * @param algorithmRequest
     * @return
     */
    @Override
    public String getAlgorithmCode(AlgorithmRequest algorithmRequest) {
        try {
            AlgorithmResponse algorithmResponse = aBtestFacadeService.getAlgorithmCode(algorithmRequest);
            if (algorithmResponse != null && !StringUtils.isEmpty(algorithmResponse.getAlgorithmCode())) {
                return algorithmResponse.getAlgorithmCode();
            } else {
                logger.error(" 返回AlgorithmCode为空");
                return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
            }

        } catch (Exception e) {
            logger.error(" 调用abtest失败 {}", e);
            return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
        }
    }
}
