package com.bxm.adx.common.market.failover;

import com.bxm.adx.common.market.MarketFailover;
import com.bxm.adx.common.market.MarketOrders;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author allen
 * @date 2021-04-20
 * @since 1.0
 */
@Slf4j
@Configuration
public class ClassPathFileReaderMarketFailover implements MarketFailover {

    @Override
    public byte[] fetch(String appId, MarketOrders orders) {
        try {
            ClassPathResource resource = new ClassPathResource("/failover/" + appId);
            InputStream inputStream = resource.getInputStream();
            return IOUtils.readFully(inputStream, inputStream.available());
        } catch (IOException e) {
            log.warn("fetch: {}", e.getMessage());
            return null;
        }
    }
}
