package com.bxm.adx.common;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by Arei on 2020/10/9.
 */
@ControllerAdvice
@Slf4j
public class ExceptionAdvice  {
    @ExceptionHandler(Exception.class)
    @ResponseBody
    public ResponseEntity<String> handleException(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error(ex.getMessage());
        }
        HttpStatus status = HttpStatus.OK;
        if (ex instanceof AdxException) {
            AdxException adxException = (AdxException) ex;
            status = HttpStatus.resolve(adxException.getCode());
        }

        ResponseEntity entity = new ResponseEntity(status);
        return entity;
    }
}
