package com.bxm.adx.common.filter;

import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>DSP抽象过滤器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 16:32
 */

@Slf4j
public abstract class AbstractDspFilter implements Filter {

    public AbstractDspFilter() {
    }

    @Override
    public void filter(FilterRequest request) {

        MarketOrders marketOrders = request.getMarketOrders();
        if (marketOrders == null) {
            log.debug(" marketOrders is null . ");
            return;
        }

        final List<String> dsps = doFilter(marketOrders);
        removeDsp(dsps, marketOrders);
    }

    /**
     * DSP相关过滤实现
     *
     * @param marketOrders
     * @return
     */
    protected abstract List<String> doFilter(MarketOrders marketOrders);

    /**
     * 移除被过滤掉的DSP
     *
     * @param positions
     * @param marketOrders
     */
    protected void removeDsp(List<String> dsps, MarketOrders marketOrders) {

    }
}
