package com.bxm.adx.common.sell.app;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.app.App;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.stereotype.Service;

/**
 * Created by Arei on 2020/9/27.
 */
@Service("appService")
public class AppServiceImpl implements AppService {
    private final Fetcher fetcher;

    public AppServiceImpl(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public App getAppById(String appId) {
        return fetcher.fetch(AdxKeyGenerator.App.getInfo(appId), App.class);
    }
}
