package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author allen
 * @since 2019-12-18
 */
@Configuration
@Slf4j
public class PositionServiceImpl implements PositionService {
    private final static List<String> APPID = Arrays.asList(
            "d391fb13218844b09e0b1598ca149571",
            "38da1ae56ce645c9a538460807f8b8f8",
            "03c95ba491c34508880f00dd0e480755",
            "c9e64b6333ed43559caaef7a90e89e26"
    );
    private final static List<String> PACKAGENAME = Arrays.asList(
            "com.wquant.bottle",
            "cn.zsbro.bigwhale",
            "com.bxm.sdk.lll",
            "com.bxm.sdkdemo"
    );
    private final PositionDao positionDao;
    private final AppService appService;
    private final Fetcher fetcher;

    public PositionServiceImpl(PositionDao positionDao, AppService appService, Fetcher fetcher) {
        this.positionDao = positionDao;
        this.appService = appService;
        this.fetcher = fetcher;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        //TODO 这里有可能传的是appPositionId
        Position position = positionDao.getByPositionId(positionId);
        if (position == null) {
            position = getByAppPositionId(positionId);
        }
        return position;
    }

    @Override
    public boolean verifyPosition(Position position, SspRequest sspRequest) {
        String posId = position.getPositionId();
        String appId = null;
        String packageName = null;

        if (null != position) {
            appId = position.getAppId();
        }
        //如果广告位缓存拿不到appid
        if (StringUtils.isEmpty(appId)) {
            if (log.isWarnEnabled()) {
                log.warn("position={} appid is not exist", posId);
            }
            return false;
        }

        if (null != sspRequest) {
            App app = sspRequest.getApp();
            if (null != app) {
                packageName = app.getBundle();
            }
        }
        //如果请求中没带包名
        if (StringUtils.isEmpty(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("app packageName is not exist, pos={}", posId);
            }
            if (APPID.contains(appId)) {
                return true;
            }
            return false;
        }
        //如果是内部包名，跳过验证
        List<String> pns = fetcher.fetchList(CacheKeys.getPackageNameKey(), String.class);
        if (CollectionUtils.isEmpty(pns)) {
            if (PACKAGENAME.contains(packageName)) {
                if (log.isWarnEnabled()) {
                    log.warn("use inner packageName={}, pos={}", packageName, posId);
                }
                return true;
            }
        } else {
            if (pns.contains(packageName)) {
                if (log.isWarnEnabled()) {
                    log.warn("use inner packageName={}, pos={}", packageName, posId);
                }
                return true;
            }
        }

        com.bxm.adx.facade.rule.app.App app = appService.getAppById(appId);
        //如果找不到appid对应的应用
        if (null == app) {
            if (log.isWarnEnabled()) {
                log.warn("appId: {} is not exist", appId);
            }
            return false;
        } else {
            String realPackName = app.getAppPackageName();
            //如果应用信息中拿不到包名
            if (StringUtils.isEmpty(realPackName)) {
                if (log.isWarnEnabled()) {
                    log.warn("appId: {} realPackName is null", appId);
                }
                if (APPID.contains(appId)) {
                    return true;
                }
                return false;
            } else {
                if (realPackName.equalsIgnoreCase(packageName)) {
                    return true;
                } else {
                    //如果两个包名对不上
                    if (log.isWarnEnabled()) {
                        if (StringUtils.isEmpty(posId)) {
                            posId = "-";
                        }
                        log.warn("verify err, pos={},real={},now={}", posId, realPackName, packageName);
                    }
                    if (APPID.contains(appId)) {
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return positionDao.getInteractByPositionId(positionId);
    }

    @Override
    public Position getByPositionIdNativeCache(String positionId) {
        return positionDao.getByPositionIdNativeCache(positionId);
    }
}
