package com.bxm.adx.common;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * @author allen
 * @since 2019-12-16
 */
public class AdxConstants {
    public static final Integer RESULT_OK = 0;

    public static final byte YES = 1;
    public static final byte NO = 0;

    public static final int ADX_REQ = 15001;
    public static final int ADX_RESP = 15104;
    public static final int DSP_REQ = 15002;
    public static final int DSP_RESP = 15103;

    /**
     * 广告创意类型
     */
    public enum Type {
        NATIVE(1),
        IMAGE(2),
        VIDEO(3),
        TEXT(4),
        INSPIRE_VIDEO(5);
        private Integer type;

        Type(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }

        public static Integer getTypeByPositionScene(Byte scene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(scene.intValue());
            if (sceneTypeEnum == null) {
                return null;
            }
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW:
                    return NATIVE.getType();
                case BOOT:
                    return IMAGE.getType();
                case SCREEN:
                    return IMAGE.getType();
                case BUTTON:
                    return IMAGE.getType();
                case INFORMATION_FLOW_SELF_RENDERING:
                    return NATIVE.getType();
                case BANNER:
                    return IMAGE.getType();
                case ICON:
                    return IMAGE.getType();
                case VIDEO:
                    return VIDEO.getType();
                case INSPIRE_VIDEO:
                    return INSPIRE_VIDEO.getType();
                case SELF_RENDERING:
                    return NATIVE.getType();
                case INFORMATION_FLOW_IMMERSIVE_VIDEO:
                    return VIDEO.getType();
                case TAB_PAGE:
                    return NATIVE.getType();
                case PUSH:
                    return NATIVE.getType();

            }
            return null;
        }
    }

    /**
     * ssp协议广告点击操作类型对应adx协议CType
     */
    public enum Action {
        UNKNOW(0),
        DOWNLOAD_ANDROID(2),
        DOWNLOAD_IOS(3),
        WEB_VIEW(6),
        DEEP_LINK(9),
        DEEP_LINK_DOWNLOAD(11);
        private int action;

        Action(int action) {
            this.action = action;
        }

        public int getAction() {
            return action;
        }

        public static boolean isAppDownload(Integer action) {
            if (action == null) {
                return false;
            }
            Action act = Arrays.stream(Action.values())
                    .filter(a -> a.getAction() == action.intValue())
                    .findFirst()
                    .orElse(UNKNOW);
            if (act == DOWNLOAD_ANDROID || act == DOWNLOAD_IOS || act == DEEP_LINK_DOWNLOAD) {
                return true;
            } else {
                return false;
            }
        }
    }

    public enum ActivityErr {
        DOUDI,
        MEI_DOU_ZHU
    }

    /**
     * 内部埋点modeltype
     */
    public enum CounterMt {
        IMP("1"),
        CLICK("2"),

        V_START("3"),
        V_1_4("4"),
        V_1_2("5"),
        V_3_4("6"),
        V_END("7"),
        V_MUTE("8"),
        V_SKIP("9"),
        V_CLOSED("10"),
        V_SUSPEND("11"),
        V_PROCEED("12"),
        V_BAD_NET("18"),
        V_FULL_SCREEN_PLAY("19"),
        V_CLOSE_FULL_SCREEN_PLAY("20"),
        V_CLOSE_MUTE_PLAY("21"),
        V_LEAVE("26"),

        APP_D_START("13"),
        APP_D_END("14"),
        APP_IN_START("15"),
        APP_IN_END("16"),
        APP_ACT("22"),

        DP_START("23"),
        DP_SUCCESS("24"),
        DP_FAIL("25"),;
        private String mt;

        CounterMt(String mt) {
            this.mt = mt;
        }

        public String getMt() {
            return mt;
        }
    }

    /**
     * 网络类型
     */
    public enum ConnectionType {
        UNKNOW(0, "unknow"),
        WIFI(1, "wifi"),
        UNKNOW_XG(2, "xg"),
        _2G(3, "2g"),
        _3G(4, "3g"),
        _4G(5, "4g"),
        _5G(6, "5g"),
        ETHERNET(7, "ethernet");
        private Integer type;
        private String network;

        ConnectionType(Integer type, String network) {
            this.type = type;
            this.network = network;
        }

        public Integer getType() {
            return type;
        }

        public String getNetwork() {
            return network;
        }

        public static Integer getType(String typeStr) {
            if (StringUtils.isEmpty(typeStr)) {
                return UNKNOW.type;
            }
            return Arrays.stream(ConnectionType.values()).
                    filter(connectionType -> connectionType.network.equalsIgnoreCase(typeStr))
                    .findFirst().orElse(UNKNOW).type;
        }

        public static ConnectionType getType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(ConnectionType.values()).
                    filter(connectionType -> connectionType.type.equals(type))
                    .findFirst().orElse(UNKNOW);
        }

        public static ConnectionType getType(Integer type, String os) {
            if (type == null) {
                return UNKNOW;
            }
            if (StringUtils.isEmpty(os)) {
                return UNKNOW;
            }
            if (!"ios".equalsIgnoreCase(os)) {
                return UNKNOW;
            }
            switch (type) {
                case 1:
                    return WIFI;
                case 2:
                    return _2G;
                case 3:
                    return _3G;
                case 4:
                    return _4G;
                default:
                    return UNKNOW;
            }
        }
    }

    /**
     * 运营商
     */
    public enum Carrier {
        MOBILE(0),
        TELECOM(1),
        UNICOM(3),
        UNKNOW(4);
        private Integer carrier;

        Carrier(Integer carrier) {
            this.carrier = carrier;
        }

        public static Carrier getCarrier(Integer carrier) {
            if (carrier == null) {
                return UNKNOW;
            }
            return Arrays.stream(Carrier.values()).
                    filter(carrier1 -> carrier1.carrier.equals(carrier)).findFirst().orElse(UNKNOW);
        }
    }

    /**
     * 上报宏参替换
     */
    public enum Macro {
        __X_DOWN__,
        __Y_DOWN__,
        __X_UP__,
        __Y_UP__,
        __REQPW__,
        __REQPH__,
        __ACTPW__,
        __ACTPH__,
        __VI_DURATION__,
        __STATUS__
        ;
    }

    public enum AssetType {
        UNKNOW(0),
        TITLE(1),
        CONTENT(2),
        BTN_TEXT(3),
        BTN_CONTENT(4),
        PRICE(5),
        ICON(6),
        LARGE_IMG(7),
        BTN_IMG(8),
        DESC(9),
        RATING(10),
        VIDEO(11),
        REWARDER_VIDEO(12),
        ;
        private Integer type;

        AssetType(Integer type) {
            this.type = type;
        }

        public static AssetType getAssetType(Integer type) {
            if (type == null) {
                return UNKNOW;
            }
            return Arrays.stream(AssetType.values())
                    .filter(at -> at.type.equals(type))
                    .findFirst()
                    .orElse(UNKNOW);
        }
    }

    public enum Imsi {
        MOBILE("46000"),
        UNICOM("46001"),
        TELECOM("46003");
        private String imsi;

        Imsi(String imsi) {
            this.imsi = imsi;
        }

        public String getImsi() {
            return imsi;
        }
    }
}
