package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Set;

/**
 * @author allen
 * @since 2019-12-18
 */
@Slf4j
@Configuration
public class DefaultPriorityExchanger implements PriorityExchanger {

    private final AdxProperties properties;
    private final Exchanger exchanger;

    public DefaultPriorityExchanger(AdxProperties properties, Exchanger exchanger) {
        this.properties = properties;
        this.exchanger = exchanger;
    }

    @Override
    public List<Deal> exchange(MarketOrders orders) {
        BidRequest request = orders.getBidRequest();
        List<MarketRequest> requestList = orders.getRequests();
        if (CollectionUtils.isEmpty(requestList)) {
            return null;
        }
        List<Deal> result = Lists.newArrayList();
        for (MarketRequest marketRequest : requestList) {
            Set<Buyer> buyers = marketRequest.getBuyers();
            Set<Position> positions = marketRequest.getPositions();
            Set<String> positionIds = Sets.newHashSet();
            for (Position position : positions) {
                positionIds.add(position.getPositionId());
            }
            List<Impression> imps = Lists.newArrayList(request.getImps());

            imps.removeIf(impression -> !positionIds.contains(impression.getTag_id()));
            final BidRequest e = new BidRequest();
            BeanUtils.copyProperties(request, e);
            e.setImps(imps);

            List<Deal> deals = exchanger.bidding(e, buyers);
            if (CollectionUtils.isNotEmpty(deals)) {
                for (Deal deal : deals) {
                    if (deal.isBidSuccess()) {
                        result.add(deal);
                    }
                }
            }
            // 如果当前有竞价结果，那么直接返回
            if (CollectionUtils.isNotEmpty(result)) {
                return result;
            }
        }
        return result;
    }
}
