package com.bxm.adx.common.sell.creatives;

import com.alibaba.fastjson.JSON;
import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.enums.SeconeEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.adx.common.ingetration.AbtestServiceIntegration;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.*;
import java.util.concurrent.*;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/8/6 10:36
 */
@Slf4j
@Service
public class MediaEntranceCreativesServiceImpl implements MediaEntranceCreativesService{


    private ExecutorService pool;

    public MediaEntranceCreativesServiceImpl() {
        this.pool = new ThreadPoolExecutor(200, 400, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(), new NamedThreadFactory("assets"));
    }
    @Autowired
    private JedisFetcher fetcher;

    @Autowired
    AbtestServiceIntegration abtestServiceIntegration;

    @Override
    public String best(String positionId ,String uid) {
        Boolean checkPosition = checkPosition(positionId);
        AssetsFlowConfig assetsFlowConfig= getAssetsFlowConfig();
        if (assetsFlowConfig!= null && checkPosition && threeCondition(uid,assetsFlowConfig)) {
            //20一下的都是测试
            String result = newBest(positionId, uid ,assetsFlowConfig);
            if (StringUtils.isNotBlank(result)) {
                return result;
            }
        }

        String flowRates = fetcher.fetchWithSelector(MediaEntranceCreativesBuider.flowRate(positionId),String.class, 2);
        if (StringUtils.isBlank(flowRates)){
           // log.warn("Position {} get creatives is empty .",positionId );
            //返回一个默认的
            return null;
        }

        Map<String,Object> result = JSON.parseObject(flowRates,Map.class);
        Map<String,Double> reateMap = Maps.newHashMap();
        if(MapUtils.isNotEmpty(result)) {
            result.forEach((key, value) -> {
                reateMap.put(key, TypeHelper.castToDouble(value));
            });
        }

        return get(reateMap);
    }

    @Override
    public String abTestBest(AssetsRequest assetsRequest) {
        AlgorithmRequest algorithmRequest=new AlgorithmRequest();
        algorithmRequest.setPositionId(assetsRequest.getPositionId());
        algorithmRequest.setRequestId(assetsRequest.getBidid());
        algorithmRequest.setSceneCode(SeconeEnum.SECONE_ONE.getSeconeCode());
        algorithmRequest.setUserId(assetsRequest.getUid());
        String algorithmCode = abtestServiceIntegration.getAlgorithmCode(algorithmRequest);
        //A1算法
        if(StringUtils.equalsIgnoreCase(algorithmCode, AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_ONE.getAlgorithmCode())){
            return A1Best(assetsRequest);
        }

        String flowRates = fetcher.fetchWithSelector(MediaEntranceCreativesBuider.flowRate(assetsRequest.getPositionId()),String.class, 2);
        if (StringUtils.isBlank(flowRates)){
            return null;
        }

        Map<String,Object> result = JSON.parseObject(flowRates,Map.class);
        Map<String,Double> reateMap = Maps.newHashMap();
        if(MapUtils.isNotEmpty(result)) {
            result.forEach((key, value) -> {
                reateMap.put(key, TypeHelper.castToDouble(value));
            });
        }

        return get(reateMap);
    }


    private String A1Best(AssetsRequest assetsRequest) {
        //广告位下面所有开启的素材
        //List<String> allAssets = fetcher.hfetchListWithSelector(MediaEntranceCreativesBuider.positionAllCreatives(), assetsRequest.getPositionId(), String.class, 2);
        List<String> allAssets =assetsRequest.getAssetIdsList();

        if (CollectionUtils.isEmpty(allAssets)) {
            return null;
        }
        if(allAssets.size()==1){
            return allAssets.get(0);
        }
        List<AssetsSort> assetsSortList = new ArrayList<>();
        List<Future<AssetsSort>> futures = Lists.newArrayList();
        for (String assetsId : allAssets) {
            Future<AssetsSort> future = pool.submit(() -> {
                AssetsSort assetsSort = new AssetsSort();
                assetsSort.setAssetId(assetsId);
                assetsSort.setCtr(ctr(assetsRequest.getPositionId(), assetsId));
                return assetsSort;
            });
            futures.add(future);
        }
        for (Future<AssetsSort> future : futures) {
            try {
                AssetsSort assetsSort = future.get();
                assetsSortList.add(assetsSort);
            } catch (InterruptedException | ExecutionException e) {
                if (log.isErrorEnabled()) {
                    log.error("get: {}", e);
                }
            }
        }
        Collections.sort(assetsSortList);
        return assetsSortList.get(0).getAssetId();
    }




    private String newBest(String positionId, String uid,AssetsFlowConfig assetsFlowConfig) {
        //广告位下面所有开启的素材
        List<String> allAssets = fetcher.hfetchListWithSelector(MediaEntranceCreativesBuider.positionAllCreatives(), positionId, String.class, 2);
        if (CollectionUtils.isEmpty(allAssets)) {
            return null;
        }
        if(allAssets.size()==1){
            return allAssets.get(0);
        }
        //默认15-20  是0.9
        Double α = assetsFlowConfig.getΑ1();
        //10-15 是0.8
        if (twoCondition(uid,assetsFlowConfig)) {
            α = assetsFlowConfig.getΑ2();
        }
        Boolean flag=false;
        //0-10不走 α 参数 ，直接走广告位
        if(oneCondition(uid , assetsFlowConfig)){
            flag = true;
        }
        List<AssetsSort> assetsSortList = new ArrayList<>();
        List<Future<AssetsSort>> futures = Lists.newArrayList();
        for (String assetsId : allAssets) {
            Double finalΑ = α;
            Boolean finalFlag = flag;
            Future<AssetsSort> future = pool.submit(() -> {
                AssetsSort assetsSort = new AssetsSort();
                assetsSort.setAssetId(assetsId);
                if(finalFlag){
                    assetsSort.setCtr(ctr(positionId, assetsId));
                }else{
                    assetsSort.setCtr(newCtr(positionId, assetsId,uid, finalΑ));
                }
                return assetsSort;
            });
            futures.add(future);
        }
        for (Future<AssetsSort> future : futures) {
            try {
                AssetsSort assetsSort = future.get();
                assetsSortList.add(assetsSort);
            } catch (InterruptedException | ExecutionException e) {
                if (log.isErrorEnabled()) {
                    log.error("get:", e);
                }
            }
        }
        Collections.sort(assetsSortList);
        //log.warn("新版素材的排序Sorted: {}，广告位是:{},uid :{}", assetsSortList,positionId,uid);
        return assetsSortList.get(0).getAssetId();
    }

    public static void main(String[] args) {
        AssetsFlowConfig assetsFlowConfig =new AssetsFlowConfig();
        assetsFlowConfig.setOneCondition(30);
        assetsFlowConfig.setTwoCondition(40);
        assetsFlowConfig.setThreeCondition(50);
        assetsFlowConfig.setΑ1(0.9);
        assetsFlowConfig.setΑ2(0.8);
        System.out.println(JSON.toJSONString(assetsFlowConfig));
        for(int i=70;i<1200;i++){
            int hashCode = (i+"").hashCode();
            int abs = Math.abs(hashCode % 100);
            if(abs>40 &&abs<50){
                System.out.println(i+"---"+abs);
            }
        }
    }

    /**
     * 获取ctr
     * @param positionId
     * @param assetsId
     * @return
     */
    private Double ctr(String positionId ,String assetsId){
        //广告位维度的ctr
        return findByKeyCtr(assetsId,MediaEntranceCreativesBuider.positionAllAssets(positionId));
    }
    private Double newCtr(String positionId ,String assetsId ,String uid ,Double α){
        //广告位维度的ctr
        Double positionCtr = findByKeyCtr(assetsId,MediaEntranceCreativesBuider.positionAllAssets(positionId));
        //用户维度的ctr
        Double userCtr = findByKeyCtr(assetsId,MediaEntranceCreativesBuider.userAllAssets(uid));
        //final  ctr = α * ctr1 + （1-α）* ctr2 , 其中alpha为超参数，需要实验通过实验选取最优值
        return  α * positionCtr +(1-α) * userCtr;
    }
    /**
     * 维度的ctr
     * @param
     * @param assetsId
     * @return
     */
    private Double findByKeyCtr(String assetsId, KeyGenerator keyGenerator){
        AssetsCounter assetsCounter = fetcher.hfetchWithSelector(keyGenerator,assetsId,AssetsCounter.class,2);
        if(assetsCounter ==null || assetsCounter.getExposurePv()==0){
             assetsCounter =new AssetsCounter();
        }
        //如果曝光-点击小于0    alpha =alpha+1，beta =20
        //如果曝光-点击>=0      alpha =alpha+1，beta = beta+20
        if(assetsCounter.getExposurePv() -assetsCounter.getClickPv() < 0){
            return betasampler(assetsCounter.getClickPv() + 1,1);
        }
        //全局维度  ctr1 = rbeta(click, show - click)， 其中click为素材在媒体的全局click，show为素材在媒体的全局show
        return betasampler(assetsCounter.getClickPv()+1,1 + assetsCounter.getExposurePv()-assetsCounter.getClickPv());
    }



    //beta分布采样
    public static double betasampler(double alpha,double beta){
        BetaDistribution betas=new BetaDistribution(alpha,beta);
        return betas.sample();
    }

    /**
     * 检查是否是灰度广告位
     * @param positionId
     * @return
     */
    private  Boolean checkPosition(String positionId){
        if(StringUtils.isEmpty(positionId)){
            return false;
        }
        String result = fetcher.fetchWithSelector(MediaEntranceCreativesBuider.tmepPosition(),String.class,2) ;
        if(StringUtils.isEmpty(positionId)){
            return  false;
        }
        List<String> list= Arrays.asList(result.split(","));
        if(list.contains(positionId)){
            return true;
        }
        return false;
    }

    private AssetsFlowConfig getAssetsFlowConfig(){
        AssetsFlowConfig result = fetcher.fetchWithSelector(MediaEntranceCreativesBuider.tmepConfig(),AssetsFlowConfig.class,2) ;
        return result;
    }


    /**
     * 分桶
     * @param uid
     * @return
     */
    private static boolean oneCondition(String uid,AssetsFlowConfig assetsFlowConfig) {
        if(StringUtils.isEmpty(uid)){
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getOneCondition();
    }

    private static boolean twoCondition(String uid,AssetsFlowConfig assetsFlowConfig) {
        if(StringUtils.isEmpty(uid)){
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getTwoCondition();
    }
    private static boolean threeCondition(String uid,AssetsFlowConfig assetsFlowConfig) {
        if(StringUtils.isEmpty(uid)){
            return false;
        }
        int hashCode = uid.hashCode();
        int abs = Math.abs(hashCode % 100);
        return abs < assetsFlowConfig.getThreeCondition();
    }

    public String get(Map<String, Double> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        } else {
            double chanceRate = RandomUtils.nextDouble(0.0D, sum(map));
            Set<Map.Entry<String, Double>> entrySet = map.entrySet();
            double rate = 0.0D;
            Iterator var7 = entrySet.iterator();

            Map.Entry entry;
            do {
                if (!var7.hasNext()) {
                    return (String)((Map.Entry)entrySet.iterator().next()).getKey();
                }

                entry = (Map.Entry)var7.next();
                rate = add(new double[]{rate, (Double)entry.getValue()});
            } while(rate < chanceRate);

            return (String)entry.getKey();
        }
    }

    private static double sum(Map<String, Double> rates) {
        double sum = 0.0D;
        Iterator var3 = rates.values().iterator();

        while(var3.hasNext()) {
            Double d = (Double)var3.next();
            if (d > 0.0D) {
                sum = add(new double[]{sum, d});
            }
        }

        return sum;
    }

    public static double add(double... values) {
        double val1 = values[0];

        for(int i = 1; i < values.length; ++i) {
            val1 = BigDecimal.valueOf(val1).add(BigDecimal.valueOf(values[i])).setScale(4, 1).doubleValue();
        }

        return val1;
    }
}
