package com.bxm.adx.common.sell.position.verify;

import org.springframework.util.StringUtils;

import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.warcar.utils.StringHelper;

/**
 * Created by Arei on 2020/12/14.
 */
public abstract class AbstractVerify {

    protected AbstractVerify nextVerify;

    public void setNextVerify(AbstractVerify nextVerify) {
        this.nextVerify = nextVerify;
    }

    public abstract void verify(Context context);

    public void doVerify(Context context) {
        verify(context);

        if (null != nextVerify) {
            nextVerify.doVerify(context);
        }
    }

    protected boolean isNeedVerifyAppId(String ver) {
        if (StringUtils.isEmpty(ver)) {
            return false;
        }
        return StringHelper.isNewVersion(SdkVersionEnum.SUPPORT_EXCEPTION_325.getVersion(), ver);
    }
}
