/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Deal {
    private Buyer buyer;
    private byte[] request;
    private byte[] response;
    private BidRequest bidRequest;
    private BidResponse bidResponse;
    private AdxErrEnum adxErrEnum;

    public Deal(Buyer buyer, byte[] request, byte[] response, BidRequest bidRequest) {
        this.buyer = buyer;
        this.request = request;
        this.response = response;
        this.bidRequest = bidRequest;
    }

    public Deal(Buyer buyer, byte[] request, byte[] response, BidRequest bidRequest, BidResponse bidResponse) {
        this.buyer = buyer;
        this.request = request;
        this.response = response;
        this.bidRequest = bidRequest;
        this.bidResponse = bidResponse;
    }

    public Deal(Buyer buyer, byte[] request, BidRequest bidRequest, AdxErrEnum adxErrEnum) {
        this.buyer = buyer;
        this.request = request;
        this.bidRequest = bidRequest;
        this.adxErrEnum = adxErrEnum;
    }

    public boolean isBidSuccess() {
        return Objects.nonNull(this.getBidResponse());
    }

    public BidResponse getBidResponse() {
        if (null == this.bidResponse) {
            BuyModelAdapter modelAdapter = this.buyer.getModelAdapter();
            if (null != this.response && this.response.length > 0) {
                this.bidResponse = modelAdapter.buildResponse(this.response);
                if (null != this.bidResponse) {
                    if (StringUtils.isEmpty((Object)this.bidResponse.getId())) {
                        this.bidResponse.setId(this.bidRequest.getId());
                    }
                    if (!CollectionUtils.isEmpty(this.bidResponse.getSeat_bid())) {
                        List bidList = this.bidResponse.getSeat_bid().stream().map(SeatBid::getBid).flatMap(Collection::stream).collect(Collectors.toList());
                        for (Bid bid : bidList) {
                            if (StringUtils.isEmpty((Object)bid.getTag_id())) {
                                bid.setTag_id(this.bidRequest.getImps().get(0).getTag_id());
                            }
                            if (!StringUtils.isEmpty((Object)bid.getCreate_id())) continue;
                            bid.setCreate_id(RandomStringUtils.randomAlphabetic((int)6));
                        }
                    }
                }
            }
        }
        return this.bidResponse;
    }

    public Buyer getBuyer() {
        return this.buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public BidRequest getBidRequest() {
        return this.bidRequest;
    }

    public AdxErrEnum getAdxErrEnum() {
        return this.adxErrEnum;
    }
}

