/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.ingetration.AdxCounterServiceIntegration;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeContext;
import com.bxm.adx.common.market.exchange.ExchangeParam;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Geo;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeCallable
implements Callable<Deal> {
    private static final Logger log = LoggerFactory.getLogger(ExchangeCallable.class);
    private final Buyer buyer;
    private final BidRequest bidRequest;
    private final AdxCounterServiceIntegration service;
    private final BuyerMeter buyerMeter;
    private final ExchangeParam exchangeParam;

    public ExchangeCallable(Buyer buyer, BidRequest bidRequest, AdxCounterServiceIntegration service, BuyerMeter buyerMeter, ExchangeParam exchangeParam) {
        this.buyer = buyer;
        this.bidRequest = bidRequest;
        this.service = service;
        this.buyerMeter = buyerMeter;
        this.exchangeParam = exchangeParam;
    }

    private void dot(BidRequest request, Buyer buyer, Integer mt) {
        List<AdxCounterDTO> dtos = this.build(request, buyer, mt);
        for (AdxCounterDTO dto : dtos) {
            try {
                this.service.counter(dto);
            }
            catch (Exception e) {
                log.warn("counter: ", (Throwable)e);
            }
        }
    }

    private List<AdxCounterDTO> build(BidRequest request, Buyer buyer, Integer mt) {
        ArrayList dtos = Lists.newArrayList();
        List<Impression> imps = request.getImps();
        for (Impression imp : imps) {
            Device device = request.getDevice();
            AdxCounterDTO dto = new AdxCounterDTO();
            dto.setT(Objects.toString(System.currentTimeMillis()));
            dto.setIp(device.getIp());
            dto.setUa(device.getUa());
            dto.setMac(device.getMac());
            dto.setOs(device.isAndroid() ? "1" : (device.isIos() ? "2" : "0"));
            dto.setImei(device.getImei());
            dto.setImei_md5(device.getImei_md5());
            dto.setAnid(device.getDpid());
            dto.setAnid_md5(device.getDpid_md5());
            dto.setOaid(device.getOaid());
            dto.setIdfa(device.getIdfa());
            dto.setIdfa_md5(device.getIdfa_md5());
            dto.setDevb(null);
            dto.setDevm(null);
            dto.setNet(this.getNet(device));
            Geo geo = device.getGeo();
            if (Objects.nonNull(geo)) {
                dto.setLon(Objects.toString(geo.getLon()));
                dto.setLat(Objects.toString(geo.getLat()));
            }
            dto.setMt(mt);
            dto.setBidid(request.getId());
            dto.setTagid(imp.getTag_id());
            Dsp dsp = buyer.getDsp();
            if (Objects.isNull(dsp)) continue;
            dto.setDspid(Objects.toString(dsp.getId()));
            dto.setCreateid(null);
            dto.setWin(null);
            dto.setStatus(null);
            dto.setActid(null);
            dto.setScene(null);
            dtos.add(dto);
        }
        return dtos;
    }

    private String getNet(Device device) {
        Integer connectionType = device.getConnection_type();
        return Objects.toString(connectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deal call() {
        String name = this.buyer.getCode();
        BuyModelAdapter modelAdapter = this.buyer.getModelAdapter();
        if (null == modelAdapter) {
            log.warn("BuyModelAdapter [{}] not found!", (Object)name);
            return null;
        }
        byte[] request = null;
        try {
            this.dot(this.bidRequest, this.buyer, AdxMtEnum._102.getOriginal());
            ExchangeContext.putBidRequest(this.bidRequest);
            ExchangeContext.putBuyer(this.buyer);
            ExchangeContext.putDispatchConfig(this.exchangeParam.getDispatcherConfigId());
            ExchangeContext.putDispatch(this.exchangeParam.getDispatcher());
            request = modelAdapter.buildRequest(this.bidRequest);
            if (ArrayUtils.isEmpty((byte[])request)) {
                Deal deal = null;
                return deal;
            }
            this.buyerMeter.increaseRequest(this.buyer);
            byte[] response = this.offer(request);
            if (ArrayUtils.isEmpty((byte[])response)) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            Deal deal = new Deal(this.buyer, request, response, this.bidRequest);
            if (!deal.isBidSuccess()) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            this.buyerMeter.increasePadding(this.buyer);
            this.dot(this.bidRequest, this.buyer, AdxMtEnum._103.getOriginal());
            Deal deal2 = deal;
            return deal2;
        }
        catch (AdxException e) {
            AdxErrEnum adxErrEnum = Optional.ofNullable(e.getAdxErrEnum()).orElse(AdxErrEnum.UNKNOWN_ERR);
            Deal deal = new Deal(this.buyer, request, this.bidRequest, adxErrEnum);
            return deal;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("deal call err", (Throwable)e);
            }
            Deal deal = null;
            return deal;
        }
        finally {
            ExchangeContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] offer(byte[] request) {
        byte[] response;
        long start = System.nanoTime();
        try {
            response = this.buyer.offer(request);
        }
        finally {
            this.buyerMeter.recordRequest(this.buyer, start);
        }
        return response;
    }
}

