/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.sell.position.verify.AbstractVerify;
import com.bxm.adx.common.sell.position.verify.Context;
import com.bxm.warcar.cache.Fetcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class InnerPackageNameVerify
extends AbstractVerify {
    private static final Logger log = LoggerFactory.getLogger(InnerPackageNameVerify.class);
    private static final List<String> PACKAGENAME = Arrays.asList("com.wquant.bottle", "cn.zsbro.bigwhale", "com.bxm.sdk.lll", "com.bxm.sdkdemo", "com.wuba", "com.bxm.localmastercard");
    private final Fetcher fetcher;

    public InnerPackageNameVerify(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }
        String packageName = context.getPackageName();
        if (StringUtils.isEmpty((Object)packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("packageName is null");
            }
            return;
        }
        List pns = this.fetcher.fetchList(CacheKeys.getPackageNameKey(), String.class);
        if (CollectionUtils.isEmpty((Collection)pns)) {
            if (PACKAGENAME.contains(packageName)) {
                context.setResult(true);
                return;
            }
        } else if (pns.contains(packageName)) {
            context.setResult(true);
            return;
        }
    }
}

