/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.verify.AbstractVerify;
import com.bxm.adx.common.sell.position.verify.Context;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SpecialAppIdVerify
extends AbstractVerify {
    private static final Logger log = LoggerFactory.getLogger(SpecialAppIdVerify.class);
    private static final List<String> APPID = Arrays.asList("d391fb13218844b09e0b1598ca149571", "38da1ae56ce645c9a538460807f8b8f8", "03c95ba491c34508880f00dd0e480755", "c9e64b6333ed43559caaef7a90e89e26", "ca7fc206f16a45faa6a75a7d99f378f2");

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }
        Position position = context.getPosition();
        if (null == position) {
            if (log.isWarnEnabled()) {
                log.warn("position is null");
            }
            return;
        }
        String appId = position.getAppId();
        if (StringUtils.isEmpty((Object)appId)) {
            if (log.isWarnEnabled()) {
                log.warn("appid is null");
            }
            return;
        }
        if (APPID.contains(appId)) {
            context.setResult(true);
            return;
        }
    }

    @Override
    public void setNextVerify(AbstractVerify nextVerify) {
        super.setNextVerify(nextVerify);
    }
}

