package com.bxm.adx.common.buy.dispatcher;

import lombok.Data;

import java.math.BigDecimal;

import static com.bxm.adx.common.AdxConstants.NO;
import static com.bxm.adx.common.AdxConstants.YES;

/**
 * @author allen
 * @since 2019-12-16
 */
@Data
public class Dispatcher {


    public static final byte DISPATCHER_OPENED_YES = YES;
    public static final byte DISPATCHER_OPENED_NO = NO;

    private Long id;
    private String positionId;
    private Long dspId;
    private String dspPosid;
    private String dspAppid;
    private int priority;
    private BigDecimal dspBasePrice;
    private byte opened;
    /**
     * 频次控制
     */
    private Integer frequency;
    /**
     * 平均CPM价
     */
    private BigDecimal dspAvgPrice;
    /**
     * 配置ID
     */
    private Long configId;
    /**
     * @return 是否开启流量分发
     */
    public boolean isOpened() {
        return opened == DISPATCHER_OPENED_YES;
    }
}
