package com.bxm.adx.common.filter;


import com.bxm.adx.common.market.MarketOrders;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 16:32
 */
@Data
@Builder
public class FilterRequest {

    /**
     * 交易信息集合
     */
    private MarketOrders marketOrders;

    /**
     * 被过滤掉的信息,后面排查问题可能会用到
     */
    private List<Object> list;

    /**
     * 是否要将滤掉的信息记录
     */
    private boolean isDebug;

}
