package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.request.*;
import lombok.Data;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
public class BidRequest {

    private String id;
    private Integer adx_type;
    private List<Impression> imps;
    private Integer c_type;
    private App app;
    private Device device;
    private User user;
    private Geo geo;
    private Set<String> cur;
    private Integer bid_type;
    private Integer at;
    private List<String> deal_ids;
    private Integer bill_type;
    private Integer test;
    private Integer t_max;
    private List<String> b_cat;
    private List<String> b_seat;
    private List<String> w_seat;
    private List<String> b_adv;
    private List<String> b_app;
    private String ext;
    private Integer ad_type;
    private String entrance_name;
    //@JSONField(serialize = false)
    private String sdk_ver;

    /**
     * 客户端请求接口时所使用的服务名（域名）
     */
    private String serverName;
    /**
     * 请求方式：1-SDK定时请求 2-app主动请求
     */
    private Integer request_model;

    /**
     * 判断是否时app主动请求推送广告
     * @return
     */
    public boolean isAppDrivingRequest() {
        return Objects.isNull(request_model) ? false : request_model == AdxConstants.RequestModel.DRIVING;
    }
}
