package com.bxm.adx.common.sell;

import com.bxm.adx.common.market.MarketOrders;

/**
 * @author allen
 * @since 2019-12-17
 */
public interface BidRequestWrapper {

    /**
     * 将BidRequest包装成交易市场请求单。
     * <pre>
     * List  +-------+-----------+----------+
     *       | index |    dsp    | position |
     *       +-------+-----------+----------+
     *       |   0   | dsp1      | p1,p2,p3 |
     *       +-------+------------+---------+
     *       |   1   | dsp2,dsp3 | p4       |
     *       +-------+-----------+----------+
     * </pre>
     * @param bidRequest BidRequest
     * @return 交易市场请求单
     */
    MarketOrders packing(BidRequest bidRequest);
}
