/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.adapter.builder.MonitorBuilder;
import com.bxm.adx.common.adapter.builder.SspResponseBuilder;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.domain.DomainService;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.DownloadInfo;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.Ad;
import com.bxm.adx.common.sell.ssp.resp.Asset;
import com.bxm.adx.common.sell.ssp.resp.Config;
import com.bxm.adx.common.sell.ssp.resp.Fail;
import com.bxm.adx.common.sell.ssp.resp.Image;
import com.bxm.adx.common.sell.ssp.resp.Native;
import com.bxm.adx.common.sell.ssp.resp.Text;
import com.bxm.adx.common.sell.ssp.resp.VMonitor;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ConcreteSspResponseBuilder
extends SspResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConcreteSspResponseBuilder.class);
    private AdxProperties properties;
    private PositionService positionService;
    private MonitorBuilder monitorBuilder;
    private DomainService domainService;
    private DspService dspService;

    public ConcreteSspResponseBuilder(AdxProperties properties, PositionService positionService, MonitorBuilder monitorBuilder, DomainService domainService, DspService dspService) {
        this.properties = properties;
        this.positionService = positionService;
        this.monitorBuilder = monitorBuilder;
        this.domainService = domainService;
        this.dspService = dspService;
    }

    @Override
    public void buildResult(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;
        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "\u65e0";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest, SspResponse sspResponse) {
        Device device;
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        AdxCounterParam param = null;
        if (null != bidRequest && null != (device = bidRequest.getDevice())) {
            String os = null;
            String osStr = device.getOs();
            if (!StringUtils.isEmpty((CharSequence)osStr)) {
                if ("ios".equalsIgnoreCase(osStr)) {
                    os = "2";
                }
                if ("android".equalsIgnoreCase(osStr)) {
                    os = "1";
                }
            }
            Long configId = AdxContextFactory.get().getConfigId();
            param = AdxCounterParam.builder().anid(device.getDpid()).anid_md5(device.getDpid_md5()).idfa(device.getIdfa()).idfa_md5(device.getIdfa_md5()).imei(device.getImei()).imei_md5(device.getImei_md5()).oaid(device.getOaid()).mac(device.getMac()).os(os).ip(device.getIp()).ua(device.getUa()).experimentid(configId == null ? "" : configId.toString()).build();
        }
        String url = this.domainService.replaceCountDomain(bidRequest, this.properties.getCounterBaseUrl());
        ArrayList<Ad> ads = new ArrayList(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            Long dspId = seatBid.getDspId();
            Dsp dsp = this.dspService.get(dspId);
            for (Bid bid : bids) {
                List<String> dpSuccessUrls;
                Position position;
                Long advId;
                if (param == null) {
                    param = AdxCounterParam.builder().build();
                }
                param.setBidid(e.getId());
                param.setDspid(seatBid.getDspId().toString());
                param.setCreateid(bid.getCreate_id());
                param.setTagid(bid.getTag_id());
                param.setScene(bid.getScene());
                param.setWin(bid.getPrice_str());
                param.setActid(bid.getAct_id());
                param.setStid(bid.getStid() == null ? null : bid.getStid().toString());
                if (Objects.nonNull(dsp) && Objects.nonNull(advId = dsp.getAdvertiser())) {
                    param.setAvtsid(advId.toString());
                }
                Ad ad = new Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric((int)8));
                ad.setDsp_platform(seatBid.getDsp_platform());
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                ad.setExt(bid.getExt());
                ad.setFail(Fail.of(bid.getFail()));
                ad.setPrice(bid.getPrice());
                com.bxm.adx.common.sell.ssp.resp.DownloadInfo downloadInfo = new com.bxm.adx.common.sell.ssp.resp.DownloadInfo();
                DownloadInfo di = bid.getDownload_info();
                if (Objects.nonNull(di)) {
                    BeanUtils.copyProperties((Object)di, (Object)downloadInfo);
                    ad.setDownload_info(downloadInfo);
                }
                if (Objects.isNull(position = this.positionService.getByPositionId(ad.getPlace_token()))) {
                    position = this.positionService.getByPositionId(bidRequest.getImps().get(0).getTag_id());
                    param.setTagid(position.getPositionId());
                    ad.setPlace_token(position.getPositionId());
                }
                if (null != position) {
                    Config config = this.getConfig(position, bidRequest, bid);
                    ad.setConfig(config);
                    String positionSize = position.getPositionSize();
                    if (StringUtils.isEmpty((CharSequence)positionSize)) {
                        if (log.isDebugEnabled()) {
                            log.debug("positionSize err");
                        }
                    } else {
                        Map<String, Integer> sizeMap = AdxUtils.getPositionSize(positionSize);
                        if (CollectionUtils.isEmpty(sizeMap)) {
                            if (log.isDebugEnabled()) {
                                log.debug("positionSize analysis err");
                            }
                        } else {
                            Integer w = sizeMap.get("w");
                            Integer h = sizeMap.get("h");
                            param.setW(w == null ? "" : w.toString());
                            param.setH(h == null ? "" : h.toString());
                        }
                    }
                    if (null != position.getInformationFlowTemplate()) {
                        ad.setTemplate(position.getInformationFlowTemplate());
                    }
                }
                ad.setClick_trackers(this.monitorBuilder.fillClickMonitor(bid.getClick_monitors(), url, param));
                ad.setImp_trackers(this.monitorBuilder.fillImpMonitor(bid.getImp_monitors(), url, param));
                if (AdxContextFactory.get().isOptimization() && !CollectionUtils.isEmpty(AdxContextFactory.get().getOptimizationImpUrls())) {
                    ad.getImp_trackers().addAll(AdxContextFactory.get().getOptimizationImpUrls());
                }
                ad.setFail(this.monitorBuilder.fillFailMonitor(bid.getFail(), url, param));
                ad.setDeeplink_url(bid.getDeep_link_url());
                if (StringUtils.isNotEmpty((CharSequence)bid.getDeep_link_url())) {
                    ad.setDp_tracker(this.monitorBuilder.fillDpMonitor(bid.getDpMonitor(), url, param));
                }
                if (!StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_DEEPLINK_310.getVersion(), (String)bidRequest.getSdk_ver()) && null != ad.getDp_tracker() && !CollectionUtils.isEmpty(dpSuccessUrls = ad.getDp_tracker().getAwk_success_urls())) {
                    List<String> cts = ad.getClick_trackers();
                    if (!CollectionUtils.isEmpty(cts)) {
                        cts.addAll(dpSuccessUrls);
                    } else {
                        cts = dpSuccessUrls;
                    }
                    ad.setClick_trackers(cts);
                }
                if (AdxConstants.Action.isAppDownload(ad.getAction())) {
                    ad.setAppTracker(this.monitorBuilder.fillAppTracker(bid.getApp_monitor(), url, param));
                }
                ad.setTarget_url(bid.getClick_through_url());
                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                Native an = new Native();
                ArrayList<Asset> assets = new ArrayList<Asset>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                an.setTemplate(sn.getTemplate());
                List<com.bxm.adx.common.sell.response.Asset> snAssets = sn.getAssets();
                for (com.bxm.adx.common.sell.response.Asset sa : snAssets) {
                    Asset asset = new Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    AdxConstants.AssetType assetType = AdxConstants.AssetType.getAssetType(sa.getType());
                    if (assetType == AdxConstants.AssetType.UNKNOW && log.isWarnEnabled()) {
                        log.warn("posId = {}, asset = {}", (Object)position.getPositionId(), (Object)assetType.name());
                    }
                    switch (assetType) {
                        case TITLE: {
                            Text title = new Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        }
                        case CONTENT: {
                            Text content = new Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        }
                        case BTN_TEXT: {
                            Text buttonText = new Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        }
                        case ICON: {
                            Image image = new Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            image.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(image);
                            break;
                        }
                        case LARGE_IMG: {
                            Image limg = new Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            limg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(limg);
                            break;
                        }
                        case BTN_IMG: {
                            Image bimg = new Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            bimg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(bimg);
                            break;
                        }
                        case REWARDER_VIDEO: {
                            Integer duration;
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            Video v = sa.getVideo();
                            BeanUtils.copyProperties((Object)v, (Object)video);
                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties((Object)v.getV_monitor(), (Object)vm);
                            }
                            if (null != (duration = video.getDuration())) {
                                param.setVi_duration(duration / 1000 + "");
                            }
                            video.setV_monitor(this.monitorBuilder.fillVMonitor(vm, url, param));
                            asset.setVideo(video);
                            break;
                        }
                        case POPUP_ASSET_INFO: {
                            Text popupInfo = new Text();
                            popupInfo.setText(sa.getText().getText());
                            asset.setText(popupInfo);
                            break;
                        }
                        case POPUP_WEB_URL: {
                            Text popupWebUrl = new Text();
                            popupWebUrl.setText(sa.getText().getText());
                            asset.setText(popupWebUrl);
                            break;
                        }
                        default: {
                            if (!log.isWarnEnabled()) break;
                            log.warn("posId = {}, asset = {}", (Object)position.getPositionId(), (Object)assetType.name());
                        }
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);
                ads.add(ad);
            }
        }
        ads = ads.stream().sorted(Comparator.comparing(Ad::getPrice).reversed()).collect(Collectors.toList());
        sspResponse.setAds(ads);
        sspResponse.setResult(AdxConstants.RESULT_OK);
    }

    private void bootConfig(Config config, PositionJsonConfig positionJsonConfig) {
        PositionJsonConfig.Boot boot;
        String region = null;
        if (Objects.nonNull(positionJsonConfig) && Objects.nonNull(boot = positionJsonConfig.getBoot())) {
            region = boot.getRegion();
            config.setBoot_ae_btn(boot.getFirstUsingAeButton());
        }
        config.setBoot_full_screen_click(this.getBootFullScreenClick(region));
    }

    private void screenConfig(Config config, PositionJsonConfig positionJsonConfig) {
        PositionJsonConfig.Screen screen;
        if (Objects.nonNull(positionJsonConfig) && Objects.nonNull(screen = positionJsonConfig.getScreen())) {
            config.setScreen_load_duration(screen.getMaxLoadingTime());
        }
    }

    private Integer getBootFullScreenClick(String region) {
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            IP ip = AdxContextFactory.get().getIp();
            List<String> rs = Arrays.asList(region.split(","));
            HashSet set = Sets.newHashSet();
            Boolean isWhite = null;
            for (String r : rs) {
                String[] rule = r.split("-");
                if (rule.length == 2 && Objects.isNull(isWhite)) {
                    isWhite = rule[0].equals("1") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    set.add(rule[1]);
                    continue;
                }
                set.add(rule[0]);
            }
            boolean isMatch = ip.in((Set)set);
            if (isMatch) {
                if (isWhite.booleanValue()) {
                    return 1;
                }
                return 0;
            }
            if (isWhite.booleanValue()) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private Config getConfig(Position position, BidRequest bidRequest, Bid bid) {
        Config config = new Config();
        config.setBoot_time(position.getBootTime());
        config.setClick_video_action(position.getClickVideoAction());
        config.setShow_ad_logo(position.getIsShowAdLogo());
        config.setShow_endpage(position.getIsShowEndpage());
        config.setRefreshInterval_time(position.getRefreshIntervalTime());
        config.setRefresh_model(position.getRefreshModel());
        config.setIsShowActivityCloseButton(position.getIsShowActivityCloseButton());
        config.setShowSkipButton(position.getShowSkipButton());
        config.setDownloadPopSwitch(Objects.nonNull(position.getDownloadPopSwitch()) ? position.getDownloadPopSwitch() : 0);
        config.setDownloadBarStyle(Objects.nonNull(position.getDownloadBarStyle()) ? position.getDownloadBarStyle() : 2);
        boolean isNewVersion = StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_PRELOADING_351.getVersion(), (String)bidRequest.getSdk_ver());
        if (isNewVersion) {
            config.setOpen_preloading(position.getOpenPreloading() == null ? 0 : position.getOpenPreloading());
        } else {
            config.setOpen_preloading(0);
        }
        config.setShow_title_bar(bid.getShow_title_bar() == null ? 1 : bid.getShow_title_bar());
        PositionJsonConfig positionJsonConfig = this.getPositionJsonConfig(position);
        Byte pScene = position.getPositionScene();
        if (pScene == null) {
            config.setBoot_full_screen_click(0);
        }
        PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get((Integer)pScene.intValue());
        switch (typeEnum) {
            case BOOT: {
                this.bootConfig(config, positionJsonConfig);
                config.setDownloadPopSwitch(Objects.nonNull(position.getDownloadPopSwitch()) ? position.getDownloadPopSwitch() : 1);
                config.setDownloadBarStyle(Objects.nonNull(position.getDownloadBarStyle()) ? position.getDownloadBarStyle() : 0);
                break;
            }
            case TEXT_LINK: {
                this.textLinkConfig(config, positionJsonConfig);
                if (!StringUtils.isEmpty((CharSequence)position.getPictureConstraints())) break;
                bid.setType(AdxConstants.Type.TEXT.getType());
                break;
            }
            case SCREEN: {
                this.screenConfig(config, positionJsonConfig);
            }
        }
        return config;
    }

    private PositionJsonConfig getPositionJsonConfig(Position position) {
        String jsonConfig = position.getJsonConfig();
        if (StringUtils.isNotEmpty((CharSequence)jsonConfig)) {
            PositionJsonConfig positionJsonConfig = AdxUtils.getJsonConfig(jsonConfig);
            return positionJsonConfig;
        }
        return null;
    }

    private void textLinkConfig(Config config, PositionJsonConfig positionJsonConfig) {
        PositionJsonConfig.TextLink textLink;
        Integer adLogo = null;
        if (Objects.nonNull(positionJsonConfig) && Objects.nonNull(textLink = positionJsonConfig.getTextLink())) {
            adLogo = textLink.getAdLogo();
        }
        if (Objects.isNull(adLogo)) {
            adLogo = 0;
        }
        config.setAd_logo(adLogo);
    }
}

