package com.bxm.adx.common.openlog.event.internal;

import java.util.EventObject;

import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

/**
 * dsp竞价返回事件
 * @author fgf
 * @date 2022/6/2
 */
public class DspBidEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidRequest adxRequest;
    private final BidResponse dspResponse;
    private final String dspId;
    private final BidConfig bidConfig;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxRequest
     * @param dspResponse
     * @param dspId
     * @param bidConfig
     * @throws IllegalArgumentException if source is null.
     */
    public DspBidEvent(Object source, BidRequest sspRequest, BidRequest adxRequest, BidResponse dspResponse,
                       String dspId, BidConfig bidConfig) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxRequest = adxRequest;
        this.dspResponse = dspResponse;
        this.dspId = dspId;
        this.bidConfig = bidConfig;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidRequest getAdxRequest() {
        return adxRequest;
    }

    public BidResponse getDspResponse() {
        return dspResponse;
    }

    public String getDspId() {
        return dspId;
    }

    public BidConfig getBidConfig() {
        return bidConfig;
    }
}
