package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;

/**
 * @author allen
 * @since 2019-12-16
 */
public interface PositionService {

    Position getByAppPositionId(String appPositionId);

    Position getByPositionId(String positionId);

    /**
     * 用于验证广告位的正确性
     * 通过三码合一去判断
     * 三码合一：
     *      通过请求中的广告位id --> 查询广告位对应的appId -->
     *      查询appId对应的app信息 -->
     *      比对请求体中app对象中的bundle/packagename 和app信息中的包名是否一致
     * @param position
     * @param sspRequest
     */
    boolean verifyPosition(Position position, SspRequest sspRequest);

    /**
     * 给sdk排序用的三码合一
     * @param position
     * @param appId
     * @param packageName
     * @param sdkVer
     * @return
     */
    boolean verifyPosition(Position position, String appId, String packageName, String sdkVer);

    PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId);

    Position getByPositionIdNativeCache(String positionId);

    Position getByAppPositionIdNativeCache(String appPositionId);

    Position getByPositionId(String appId, Integer w, Integer h, Integer positionType);
}
