package com.bxm.adx.common.sell.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Device implements Serializable {
    private String ua;
    @Deprecated
    private Geo geo;
    private String ip;
    private Integer device_type;
    private Integer connection_type;
    private String make;
    private String model;
    private String brand;
    private String os;
    private String osv;
    @Deprecated
    private String hwv;
    private Integer h;
    private Integer w;
    private Integer dpi;
    private Integer orientation;
    private String imei;
    private String imei_md5;
    private String idfa;
    private String idfa_md5;
    private String mac;
    private String mac_md5;
    /**
     * Android ID
     */
    private String dpid;
    /**
     * Android ID md5
     */
    private String dpid_md5;
    private String oaid;
    private String oaid_md5;
    @Deprecated
    private String cookie;
    private String imsi;
    private String ext;
    private Integer carrier;
    public boolean isAndroid() {
        return StringUtils.equalsIgnoreCase("android", os);
    }

    public boolean isIos() {
        return StringUtils.equalsIgnoreCase("ios", os);
    }
}
