package com.bxm.adx.common.sell.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class SeatBid implements Serializable {
    /**
     * DSP的出价及物料回填信息，必填
     */
    private List<Bid> bid;
    /**
     * 发起此次竞价的代理、⼴告主的id
     */
    private String seat;
    /**
     * 保留字段
     */
    private String ext;

    /**
     * 变现猫ADX流量分配对应的DSPID
     */
//    @JsonIgnore
    @JSONField(serialize = false)
    private Long dspId;

    /**
     * 配置id
     */
//    @JsonIgnore
    @JSONField(serialize = false)
    private Long configId;

    /**
     * 广告平台标识，和dspid强关联，但是区分于dspid
     * 现仅用于标识是否来自优量汇
     */
//    @JsonIgnore
    @JSONField(serialize = false)
    private Integer dsp_platform;
}
