/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.cache;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.ResponseCache;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BuyerResponseCache
implements ResponseCache {
    private static final Logger log = LoggerFactory.getLogger(BuyerResponseCache.class);
    private final Updater updater;
    private final Fetcher fetcher;

    public BuyerResponseCache(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    @Override
    public void saveResponse(BidRequest bidRequest, BidResponse bidResponse, Buyer buyer) {
        block7: {
            KeyGenerator key = this.buildKey(bidRequest, buyer);
            Dsp dsp = buyer.getDsp();
            if ((Objects.isNull(dsp.getCacheTime()) || dsp.getCacheTime() == 0L) && log.isDebugEnabled()) {
                log.debug("dsp don't support cache");
            }
            if (Objects.isNull(key)) {
                if (log.isDebugEnabled()) {
                    log.debug("uid is null , fail to save response");
                }
                return;
            }
            if (Objects.nonNull(bidResponse)) {
                try {
                    String response = new ObjectMapper().writeValueAsString((Object)bidResponse);
                    if (!dsp.isForbidden() && Objects.nonNull(dsp.getCacheTime())) {
                        this.updater.update(key, (Object)response, dsp.getCacheTime().intValue());
                    }
                }
                catch (JsonProcessingException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error("json err", (Throwable)e);
                }
            }
        }
    }

    @Override
    public BidResponse getResponse(BidRequest bidRequest, BuyerWrapper buyer) {
        KeyGenerator key = this.buildKey(bidRequest, buyer.getBuyer(), buyer.getDispatcher());
        if (Objects.isNull(key)) {
            if (log.isDebugEnabled()) {
                log.debug("uid is null , fail to save response");
            }
            return null;
        }
        BidResponse bidResponse = (BidResponse)this.fetcher.fetch(key, BidResponse.class);
        this.updater.remove(key);
        return bidResponse;
    }

    @Override
    public List<Deal> getCacheDealList(Map<BuyerWrapper, BidRequest> forCache) {
        ArrayList<Deal> dealList = new ArrayList<Deal>();
        for (Map.Entry<BuyerWrapper, BidRequest> entry : forCache.entrySet()) {
            BidResponse bidResponse;
            if (!Objects.nonNull(entry) || !Objects.nonNull(bidResponse = this.getResponse(entry.getValue(), entry.getKey()))) continue;
            Deal cache = new Deal(entry.getKey().getBuyer(), entry.getValue(), bidResponse);
            dealList.add(cache);
        }
        return dealList;
    }

    @Override
    public void removeResponse(Deal deal) {
        if (Objects.nonNull(deal)) {
            KeyGenerator keyGenerator = this.buildKey(deal.getBidRequest(), deal.getBuyer());
            this.updater.remove(keyGenerator);
        }
    }
}

