/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.cache;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.warcar.cache.KeyGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public interface ResponseCache {
    public void saveResponse(BidRequest var1, BidResponse var2, Buyer var3);

    public BidResponse getResponse(BidRequest var1, BuyerWrapper var2);

    public List<Deal> getCacheDealList(Map<BuyerWrapper, BidRequest> var1);

    public void removeResponse(Deal var1);

    default public KeyGenerator buildKey(BidRequest bidRequest, Buyer buyer) {
        Long dspId = buyer.getDsp().getId();
        Impression impression = bidRequest.getImps().iterator().next();
        String dspTagId = impression.getTag_id();
        Device device = bidRequest.getDevice();
        String uid = this.getUid(device);
        if (StringUtils.isEmpty((Object)uid)) {
            return null;
        }
        return CacheKeys.getResponseCacheKey(dspId.toString(), dspTagId, uid);
    }

    default public KeyGenerator buildKey(BidRequest bidRequest, Buyer buyer, Dispatcher dispatcher) {
        Long dspId = buyer.getDsp().getId();
        String dspTagId = dispatcher.getDspPosid();
        Device device = bidRequest.getDevice();
        String uid = this.getUid(device);
        if (StringUtils.isEmpty((Object)uid)) {
            return null;
        }
        return CacheKeys.getResponseCacheKey(dspId.toString(), dspTagId, uid);
    }

    default public String getUid(Device device) {
        if (Objects.nonNull(device.getOaid())) {
            return device.getOaid();
        }
        if (Objects.nonNull(device.getOaid_md5())) {
            return device.getOaid_md5();
        }
        if (Objects.nonNull(device.getImei())) {
            return device.getImei();
        }
        if (Objects.nonNull(device.getImei_md5())) {
            return device.getImei_md5();
        }
        if (Objects.nonNull(device.getIdfa())) {
            return device.getIdfa();
        }
        if (Objects.nonNull(device.getIdfa_md5())) {
            return device.getIdfa_md5();
        }
        if (Objects.nonNull(device.getDpid())) {
            return device.getDpid();
        }
        if (Objects.nonNull(device.getDpid_md5())) {
            return device.getDpid_md5();
        }
        return null;
    }
}

