/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.Filter;
import com.bxm.adx.common.filter.FilterRequest;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MarketOrdersFilterChain
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(MarketOrdersFilterChain.class);
    private List<Filter> list = Lists.newArrayList();

    public void doFilter(FilterRequest request) {
        this.list.forEach(l -> l.filter(request));
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map beansOfType = event.getApplicationContext().getBeansOfType(Filter.class);
        if (MapUtils.isNotEmpty((Map)beansOfType)) {
            for (Map.Entry entry : beansOfType.entrySet()) {
                this.list.add((Filter)entry.getValue());
            }
        }
        this.list.sort(Comparator.comparingInt(Filter::order));
        for (int i = 0; i < this.list.size(); ++i) {
            log.info("Filter [{}] : {} init . ", (Object)i, this.list.get(i).getClass());
        }
        log.info("All [{}] filter impl init finish .", (Object)this.list.size());
    }
}

