/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.datalog;

import com.bxm.adx.common.log.datalog.DataLog;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CachePush(value="DATA_LOG")
@Component
public class DataLogDaoImpl
implements DataLogDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(DataLogDaoImpl.class);
    private final Map<String, AtomicInteger> cache = Maps.newConcurrentMap();
    private final Updater updater;

    public DataLogDaoImpl(Updater updater) {
        this.updater = updater;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        DataLog dataLog;
        if (log.isWarnEnabled()) {
            log.warn("datalog data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (StringUtils.isEmpty((CharSequence)(dataLog = (DataLog)JsonHelper.convert((byte[])data, DataLog.class)).getSspPositionId()) || StringUtils.isEmpty((CharSequence)dataLog.getAdvertPointPositionId())) {
            return;
        }
        KeyGenerator keyGenerator = this.getKeyGenerator(dataLog.getSspPositionId(), dataLog.getAdvertPointPositionId());
        this.updater.remove(keyGenerator);
        this.updater.update(keyGenerator, (Object)dataLog, 600);
        this.cache.put(this.mapKey(dataLog.getSspPositionId(), dataLog.getAdvertPointPositionId()), new AtomicInteger(500));
    }

    private KeyGenerator getKeyGenerator(String sspPositionId, String dspPositionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "DATA_LOG", sspPositionId, dspPositionId});
    }

    @Override
    public boolean existDataLog(String sspPositionId, String dspPositionId) {
        int i;
        String key = this.mapKey(sspPositionId, dspPositionId);
        boolean exist = this.cache.containsKey(key);
        if (exist && (i = this.cache.get(key).getAndDecrement()) <= 0) {
            this.cache.remove(key);
        }
        return exist;
    }

    private String mapKey(String sspPositionId, String dspPositionId) {
        return sspPositionId + "-" + dspPositionId;
    }
}

