/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionDao;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@CachePush(value="POSITION")
@Component
public class PositionDaoImpl
implements PositionDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(PositionDaoImpl.class);
    private final Fetcher fetcher;
    private final Updater updater;
    private final com.bxm.warcar.xcache.Fetcher fetcher2;
    private final AdxProperties properties;
    private static final String APPID = "APPID";
    private static final String PID = "PID";
    private static final String TYPE = "TYPE";

    public PositionDaoImpl(Fetcher fetcher, Updater updater, com.bxm.warcar.xcache.Fetcher fetcher2, AdxProperties properties) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.fetcher2 = fetcher2;
        this.properties = properties;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return (Position)this.fetcher.fetch(this.getKeyGenerator(APPID, appPositionId), Position.class);
    }

    @Override
    public Position getByPositionId(String positionId) {
        return (Position)this.fetcher.fetch(this.getKeyGenerator(PID, positionId), Position.class);
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        PositionInteractAppentranceRefCacheVO cacheVO = (PositionInteractAppentranceRefCacheVO)this.fetcher.hfetch(AdxKeyGenerator.Position.getPositionInteract(), positionId, PositionInteractAppentranceRefCacheVO.class);
        return cacheVO;
    }

    @Override
    public Position getByPositionIdNativeCache(String positionId) {
        return (Position)this.fetcher2.fetch(new TargetFactory().cls(Position.class).keyGenerator(this.getKeyGenerator(PID, positionId)).skipNativeCache(false).expireTimeInSecond(600).build());
    }

    @Override
    public Position getByAppPositionIdNativeCache(String appPositionId) {
        return (Position)this.fetcher2.fetch(new TargetFactory().cls(Position.class).keyGenerator(this.getKeyGenerator(APPID, appPositionId)).skipNativeCache(false).expireTimeInSecond(600).build());
    }

    @Override
    public Position getByPositionId(String appId, Integer w, Integer h, Integer positionType) {
        return (Position)this.fetcher2.fetch(new TargetFactory().cls(Position.class).keyGenerator(this.getKeyGenerator(TYPE, appId + "-" + w.toString() + "*" + h + "-" + positionType.toString())).skipNativeCache(false).expireTimeInSecond(600).build());
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        String appId;
        Object o;
        if (log.isWarnEnabled()) {
            log.warn("position data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (Objects.isNull(o = parameters.get("positionId"))) {
            return;
        }
        String positionId = Objects.toString(o);
        Position position = (Position)JsonHelper.convert((byte[])data, Position.class);
        this.updater.remove(this.getKeyGenerator(APPID, position.getAppPositionId()));
        this.updater.remove(this.getKeyGenerator(PID, positionId));
        if (!StringUtils.isEmpty((Object)position.getPositionSize()) && position.getAppId().equals(this.properties.getBesAppId())) {
            this.updater.remove(this.getKeyGenerator(TYPE, this.properties.getBesAppId() + "-" + position.getPositionSize().split(" ")[0] + "-" + position.getPositionScene().toString()));
        }
        if (!StringUtils.isEmpty((Object)(appId = position.getAppId()))) {
            this.updater.srem(AdxKeyGenerator.App.getAllPositionIdFromApp((String)appId), new String[]{positionId});
        }
        if (position.isEnabled()) {
            this.updater.update(this.getKeyGenerator(APPID, position.getAppPositionId()), (Object)position);
            this.updater.update(this.getKeyGenerator(PID, positionId), (Object)position);
            if (!StringUtils.isEmpty((Object)position.getPositionSize()) && position.getAppId().equals(this.properties.getBesAppId())) {
                this.updater.update(this.getKeyGenerator(TYPE, this.properties.getBesAppId() + "-" + position.getPositionSize().split(" ")[0] + "-" + position.getPositionScene()), (Object)position);
            }
            if (!StringUtils.isEmpty((Object)appId)) {
                this.updater.supdate(AdxKeyGenerator.App.getAllPositionIdFromApp((String)appId), new String[]{positionId});
            }
        }
    }

    private KeyGenerator getKeyGenerator(String name, String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", name, value});
    }
}

