/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.shieldstrategy;

import com.bxm.adx.common.shieldstrategy.ShieldStrategy;
import com.bxm.adx.common.shieldstrategy.ShieldStrategyDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

@Component
@CachePush(value="SHIELD_STRATEGY")
public class ShieldStrategyDaoImpl
implements ShieldStrategyDao,
Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public ShieldStrategyDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public ShieldStrategy getById(String id) {
        return (ShieldStrategy)this.fetcher.fetch(this.getKeyGenerator(id), ShieldStrategy.class);
    }

    @Override
    public List<ShieldStrategy> getByIds(String shieldStrategyIds) {
        String[] shieldStrategyIdArray;
        if (StringUtils.isNotBlank((CharSequence)shieldStrategyIds) && (shieldStrategyIdArray = shieldStrategyIds.split(",")).length > 0) {
            ArrayList<ShieldStrategy> resultList = new ArrayList<ShieldStrategy>(shieldStrategyIdArray.length);
            JSONSerialization serialization = new JSONSerialization();
            JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
            try (Jedis jedis = jedisPool.getResource();){
                Pipeline pipeline = jedis.pipelined();
                for (String shieldStrategyId : shieldStrategyIdArray) {
                    ShieldStrategy ref = (ShieldStrategy)serialization.deserialize((String)pipeline.get(this.getKeyGenerator(shieldStrategyId).generateKey()).get(), ShieldStrategy.class);
                    resultList.add(ref);
                }
                pipeline.syncAndReturnAll();
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("shieldStrategyId");
        if (Objects.isNull(o)) {
            return;
        }
        String id = Objects.toString(o);
        ShieldStrategy shieldStrategy = (ShieldStrategy)JsonHelper.convert((byte[])data, ShieldStrategy.class);
        this.updater.remove(this.getKeyGenerator(id));
        if (null != shieldStrategy && null != shieldStrategy.getId()) {
            this.updater.update(this.getKeyGenerator(id), (Object)shieldStrategy);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SHIELD_STRATEGY", "ID", value});
    }
}

