package com.bxm.adx.common.sell;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.request.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BidRequest {
    /**
     * 竞价请求唯一标识，可以由流量方传入，未传入则由系统生成
     */
    private String id;
    /**
     * 广告位详情数组，至少包含一个对象
     */
    private List<Impression> imps;
    /**
     * 媒体APP信息
     */
    private App app;
    /**
     * 用户设备信息
     */
    private Device device;
    /**
     * 用户信息
     */
    private User user;
    /**
     * 地理位置信息
     */
    private Geo geo;
    /**
     * 支持的结算货币种类
     */
    private Set<String> cur;
    /**
     * 1:最高价成交，2:第二高价成交
     */
    private Integer at;
    /**
     * 测试模式
     */
    private Integer test;
    /**
     * 交易的最大超时毫秒值（包括网络延迟），默认100MS
     */
    private Integer t_max;
    private String ext;
    private Integer ad_type;
    @JSONField(serialize = false)
    private String entrance_name;
    /**
     * bxm sdk版本号
     */
    @JSONField(serialize = false)
    private String sdk_ver;

    /**
     * 客户端请求接口时所使用的服务名（域名）
     */
    @JSONField(serialize = false)
    private String serverName;
    /**
     * 请求方式：1-SDK定时请求 2-app主动请求
     */
    @JSONField(serialize = false)
    private Integer request_model;
    /**
     * 合作类型： 1 分成，2 竞价，3 包段，4 UV
     */
    @JSONField(serialize = false)
    private Integer cooperationType;
    /**
     * 对接类型：1 API，2 SDK
     */
    @JSONField(serialize = false)
    private Integer dockingMethodType;
    /**
     * bxm广告位id
     */
    @JSONField(serialize = false)
    private String bxmTagId;

    /**
     * 媒体方ID
     * @see AdxConstants.Media
     */
    @JSONField(serialize = false)
    private String mediaId;

    /**
     * 等待时间
     */
    @JSONField(serialize = false)
    private Long waitTime;

    /**
     * 超时时间
     */
    @JSONField(serialize = false)
    private Long overtime;
    /**
     * bxm-adx协议版本
     */
    private String ver;
    /**
     * 判断是否时app主动请求推送广告
     * @return
     */
    @JSONField(serialize = false)
    public boolean isAppDrivingRequest() {
        return Objects.isNull(request_model) ? false : request_model == AdxConstants.RequestModel.DRIVING;
    }
    /**
     * 媒体价格上报方式
     * @see AdxConstants.EncryptionModel
     */
    @JSONField(serialize = false)
    private Integer encModel;



    //以下为历史字段，已废除
    @Deprecated
    @JSONField(serialize = false)
    private Integer c_type;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> b_app;
    @Deprecated
    @JSONField(serialize = false)
    private Integer adx_type;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> b_cat;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> b_seat;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> w_seat;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> b_adv;
    @Deprecated
    @JSONField(serialize = false)
    private List<String> deal_ids;
    @Deprecated
    @JSONField(serialize = false)
    private Integer bill_type;
    @Deprecated
    @JSONField(serialize = false)
    private Integer bid_type;
}
