/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacros;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.utils.device.SimpleDevice;
import java.net.URLEncoder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BuildAttributeMacrosAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BuildAttributeMacrosAutoConfiguration.class);
    private final AdxProperties adxProperties;

    public BuildAttributeMacrosAutoConfiguration(AdxProperties adxProperties) {
        this.adxProperties = adxProperties;
    }

    @Bean
    public BuildAttributeStringMacros spm() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__SPM__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getSspRequest().getId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros ver() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__VER__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros bidid() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__BID_COMMON_REQUEST_ID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getSspRequest().getId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros bididCache() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__BID_COMMON_REQUEST_ID_C__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                String requestId = attribute.getSspRequest().getId();
                if (Objects.nonNull(attribute.getAdxResponse())) {
                    String responseId = attribute.getAdxResponse().getId();
                    if (!requestId.equalsIgnoreCase(responseId)) {
                        return responseId;
                    }
                    return "";
                }
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros tagId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__TAGID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getTagId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dTagId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__DTAGID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getdTagId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros timestamp() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__TIMESTAMP__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return String.valueOf(System.currentTimeMillis());
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dAppId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__DAPPID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getdAppId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros appId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__APPID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getAppId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros price() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__PRICE__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getPrice();
            }

            @Override
            public String getIfBlankValue() {
                return "__PRICE__";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros configId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__CONFIGID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getConfigId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dspId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__DSPID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getDspId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dspPrice() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__DSP_PRICE__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                String dspPrice;
                String string = dspPrice = Objects.nonNull(attribute.getDspResponsePrice()) ? attribute.getDspResponsePrice().toString() : null;
                if (StringUtils.isNotEmpty((CharSequence)dspPrice)) {
                    try {
                        dspPrice = PriceCipher.encryptWin(dspPrice, BuildAttributeMacrosAutoConfiguration.this.adxProperties.getCipherProperties().getDspPriceKey());
                        dspPrice = URLEncoder.encode(dspPrice, "UTF-8");
                    }
                    catch (Exception e) {
                        log.error("cipher err", (Throwable)e);
                    }
                }
                return dspPrice;
            }

            @Override
            public String getIfBlankValue() {
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros mediaId() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__MEDIA_ID__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getMediaId();
            }

            @Override
            public String getIfBlankValue() {
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros chgtypm() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__CHARGE_TYPE_MEDIA__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return "1";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros chgtypd() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__CHARGE_TYPE_DSP__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return "1";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros device() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__DEVICE__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                Device device = attribute.getSspRequest().getDevice();
                SimpleDevice simpleDevice = SimpleDevice.builder().imei(device.getImei()).imeiMd5(device.getImei_md5()).androidid(device.getDpid()).androididMd5(device.getDpid_md5()).oaid(device.getOaid()).oaidMd5(device.getOaid_md5()).idfa(device.getIdfa()).idfaMd5(device.getIdfa_md5()).gaid(device.getGaid()).gaidMd5(device.getGaid_md5()).build();
                return SimpleDevice.Base64Cipher.encrypt((SimpleDevice)simpleDevice);
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros encryptionModel() {
        return new BuildAttributeStringMacros(){

            @Override
            public String getMacroString() {
                return "__ENC_MODEL__";
            }

            @Override
            public String apply(BuildAttribute attribute) {
                BidRequest bidRequest = attribute.getSspRequest();
                return Objects.isNull(bidRequest.getEncModel()) ? null : bidRequest.getEncModel().toString();
            }

            @Override
            public String getIfBlankValue() {
                return "";
            }
        };
    }
}

