/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.AbstractPluginBuyersImpl;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherParam;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.buy.optimization.Optimization;
import com.bxm.adx.common.buy.optimization.OptimizationDao;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@Primary
@Configuration
public class DispatcherPluginBuyersImpl
extends AbstractPluginBuyersImpl {
    private DispatcherService dispatcherService;
    private final AdxProperties properties;
    private final DspService dspService;
    private final OptimizationDao optimizationDao;
    private final IpService ipService;

    protected DispatcherPluginBuyersImpl(PluginHolder pluginHolder, AdxProperties properties, DspService dspService, OptimizationDao optimizationDao, IpService ipService) {
        super(pluginHolder);
        this.properties = properties;
        this.dspService = dspService;
        this.optimizationDao = optimizationDao;
        this.ipService = ipService;
    }

    @Override
    public List<List<BuyerWrapper>> findAsPriority(Position position, DispatcherParam dispatcherParam) {
        Integer maxPriority;
        Set<Integer> keys;
        Map<Integer, Collection<Dispatcher>> dsps = this.dispatcherService.getPriority(position, dispatcherParam);
        Integer initSize = this.properties.getMaxCapacityOfBuyers();
        if (!MapUtils.isEmpty(dsps) && !CollectionUtils.isEmpty(keys = dsps.keySet()) && (maxPriority = (Integer)keys.stream().max(Integer::compareTo).get()) != null && maxPriority.compareTo(initSize) == 1) {
            initSize = maxPriority;
        }
        List<List<BuyerWrapper>> list = this.emptyListWithCapacity(initSize);
        Map<String, Buyer> buyers = this.getAllBuyers();
        for (Map.Entry<Integer, Collection<Dispatcher>> entry : dsps.entrySet()) {
            ArrayList buyerList;
            Integer n = entry.getKey();
            Collection<Dispatcher> value = entry.getValue();
            int index = n - 1;
            List<Object> list2 = CollectionUtils.isEmpty(list) ? null : (buyerList = list.size() > index ? list.get(index) : null);
            if (null == buyerList) {
                buyerList = Lists.newArrayList();
                list.add(index, buyerList);
            }
            for (Dispatcher dispatcher : value) {
                String dspCode;
                Buyer buyer;
                Long dspId = dispatcher.getDspId();
                Dsp dsp = this.dspService.get(dspId);
                if (null == dsp || null == (buyer = buyers.get(dspCode = dsp.getDspCode()))) continue;
                buyerList.add(new BuyerWrapper(buyer, dispatcher));
            }
        }
        list.removeIf(List::isEmpty);
        if (dispatcherParam.isSDKConcurrentModel()) {
            ArrayList<BuyerWrapper> buyerWrapperList = new ArrayList<BuyerWrapper>();
            for (List<BuyerWrapper> list3 : list) {
                if (!CollectionUtils.isNotEmpty(list3)) continue;
                buyerWrapperList.addAll(list3);
            }
            ArrayList<List<BuyerWrapper>> arrayList = new ArrayList<List<BuyerWrapper>>();
            arrayList.add(buyerWrapperList);
            return arrayList;
        }
        return list;
    }

    @Override
    public void rebuildBuyers(BidRequest bidRequest, Position position, List<List<BuyerWrapper>> list) {
        this.handleBackupEntrance(bidRequest, list);
        this.handleOptimization(position, bidRequest, list);
    }

    private List<List<BuyerWrapper>> emptyListWithCapacity(int size) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(Lists.newArrayList());
        }
        return list;
    }

    @Autowired
    public void setDispatcherService(DispatcherService dispatcherService) {
        this.dispatcherService = dispatcherService;
    }

    private void handleBackupEntrance(BidRequest request, List<List<BuyerWrapper>> buyers) {
        String entranceName = request.getEntrance_name();
        if (org.apache.commons.lang.StringUtils.isEmpty((String)entranceName)) {
            return;
        }
        if ("backup".equalsIgnoreCase(entranceName)) {
            buyers.clear();
            ArrayList<BuyerWrapper> buyerList = new ArrayList<BuyerWrapper>();
            buyers.add(buyerList);
            Map<String, Buyer> allBuyers = this.getAllBuyers();
            Buyer buyer = allBuyers.get("pangu-backup");
            if (buyer == null) {
                throw new AdxException("can't find backup-dsp ");
            }
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setDspBasePrice(BigDecimal.ZERO);
            dispatcher.setDspId(buyer.getDsp().getId());
            dispatcher.setDspAvgPrice(BigDecimal.ZERO);
            buyerList.add(new BuyerWrapper(buyer, dispatcher));
        }
    }

    private void handleOptimization(Position position, BidRequest request, List<List<BuyerWrapper>> buyers) {
        Map<String, Buyer> allBuyers;
        Buyer buyer;
        Optimization optimization = this.optimizationDao.getOptimizationByPositionId(position.getPositionId());
        if (Objects.isNull(optimization)) {
            return;
        }
        String regionCodes = optimization.getRegion();
        if (!StringUtils.isEmpty((Object)regionCodes)) {
            IP ipp = this.getIp(request);
            HashSet set = Sets.newHashSet();
            set.addAll(Arrays.asList(regionCodes.split(",")));
            if (Objects.isNull(ipp) || !ipp.in((Set)set)) {
                return;
            }
        }
        if ((buyer = (allBuyers = this.getAllBuyers()).get("optimization")) == null) {
            throw new AdxException("can't find op-dsp ");
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setDspPosid(optimization.getDspPositionId());
        buyers.add(Lists.newArrayList((Object[])new BuyerWrapper[]{new BuyerWrapper(buyer, dispatcher)}));
        AdxContextFactory.get().setOptimization(true);
    }

    private IP getIp(BidRequest bidRequest) {
        String ip;
        Device device;
        IP ipp = null;
        if (bidRequest != null && (device = bidRequest.getDevice()) != null && !StringUtils.isEmpty((Object)(ip = device.getIp()))) {
            ipp = this.ipService.analyze(ip);
            AdxContextFactory.get().setIp(ipp);
        }
        return ipp;
    }
}

