/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.creative;

import com.bxm.adx.common.creative.Creative;
import com.bxm.adx.common.creative.CreativeDao;
import com.bxm.adx.common.creative.CreativePositionRef;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachePush(value="CREATIVE")
public class CreativeDaoImpl
implements CreativeDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(CreativeDaoImpl.class);
    private final Updater updater;
    private final Fetcher fetcher;

    public CreativeDaoImpl(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    @Override
    public Creative getCreative(Long id) {
        return (Creative)this.fetcher.fetch(this.getCreativeKeyGenerator(id), Creative.class);
    }

    @Override
    public Creative getCreativeByDsp(Long dspId, String dspCreativeId) {
        return (Creative)this.fetcher.hfetch(this.getCreativeOfDspKeyGenerator(dspId), dspCreativeId, Creative.class);
    }

    @Override
    public Collection<CreativePositionRef> getRefs(String positionId) {
        return this.fetcher.hfetchall(this.getCreativePositionRefKeyGenerator(positionId), CreativePositionRef.class).values();
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("type");
        if (Objects.isNull(o)) {
            return;
        }
        switch (TypeHelper.castToInt((Object)o)) {
            case 1: {
                this.updateCreative((Creative)JsonHelper.convert((byte[])data, Creative.class));
                break;
            }
            case 2: {
                this.updateCreativePositionRef((CreativePositionRef)JsonHelper.convert((byte[])data, CreativePositionRef.class));
                break;
            }
            default: {
                log.warn("Unsupported type: {}", o);
            }
        }
    }

    private void updateCreativePositionRef(CreativePositionRef ref) {
        String positionId = ref.getPositionId();
        Long creativeId = ref.getCreativeId();
        KeyGenerator keyGenerator = this.getCreativePositionRefKeyGenerator(positionId);
        this.updater.hupdate(keyGenerator, Objects.toString(creativeId), (Object)ref);
    }

    private KeyGenerator getCreativePositionRefKeyGenerator(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "CREATIVE_POSITION_REF", "POSITIONID", positionId});
    }

    private void updateCreative(Creative creative) {
        this.updater.update(this.getCreativeKeyGenerator(creative.getId()), (Object)creative);
        this.updater.hupdate(this.getCreativeOfDspKeyGenerator(creative.getDspId()), creative.getDspCrtid(), (Object)creative);
    }

    private KeyGenerator getCreativeKeyGenerator(Long id) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "CREATIVE", "ID", id});
    }

    private KeyGenerator getCreativeOfDspKeyGenerator(Long dspId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "CREATIVE", "DSP", dspId});
    }
}

