/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.AppMonitor;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.DpMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.utils.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class MonitorWrapper {
    public static final String C_M_URLS = "__c_m_urls__";
    public static final String C_T_URL = "__c_t_url__";
    public static final String SPLIT_FOR_CMURLS = "||";
    private final AdxProperties adxProperties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public MonitorWrapper(AdxProperties adxProperties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.adxProperties = adxProperties;
        this.macrosHandler = macrosHandler;
    }

    public void monitorWrapper(BidResponse bidResponse) {
        if (Objects.isNull(bidResponse) || CollectionUtils.isEmpty(bidResponse.getSeat_bid())) {
            return;
        }
        BidRequest bidRequest = AdxContextFactory.get().getBidRequest();
        BuildAttribute buildAttribute = new BuildAttribute().setAdxResponse(bidResponse).setSspRequest(bidRequest);
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            buildAttribute.setDspId(Objects.nonNull(seatBid.getDspId()) ? seatBid.getDspId().toString() : null);
            buildAttribute.setConfigId(Objects.nonNull(seatBid.getConfigId()) ? seatBid.getConfigId().toString() : null);
            for (Bid bid : seatBid.getBid()) {
                String mediaId;
                List<String> headMonitorMediaIds;
                String positionId;
                List<String> positions;
                List<ImpMonitor> impMonitors = bid.getImp_monitors();
                if (CollectionUtils.isEmpty(impMonitors)) {
                    impMonitors = new ArrayList<ImpMonitor>();
                }
                ImpMonitor impMonitor = new ImpMonitor();
                String impUrl = this.adxProperties.getOpenLog().create(5, "down_x", "down_y", "up_x", "up_y", "ad_width", "ad_height");
                impUrl = this.macrosHandler.replaceAll(impUrl, buildAttribute.setMt(5));
                if (AdxConstants.needReplacePrice(bidRequest.getMediaId())) {
                    String price = "0";
                    if (Objects.nonNull(bid.getPrice())) {
                        price = bid.getPrice().toString();
                    }
                    impUrl = impUrl.replace("__PRICE__", price);
                }
                impMonitor.setImp_monitor_url(impUrl);
                impMonitors.add(impMonitor);
                bid.setImp_monitors(impMonitors);
                List<ClickMonitor> clickMonitors = bid.getClick_monitors();
                if (CollectionUtils.isEmpty(clickMonitors)) {
                    clickMonitors = new ArrayList<ClickMonitor>();
                }
                ClickMonitor clickMonitor = new ClickMonitor();
                String clickUrl = this.adxProperties.getOpenLog().create(6);
                clickMonitor.setClick_monitor_url(this.macrosHandler.replaceAll(clickUrl, buildAttribute.setMt(6)));
                clickMonitors.add(clickMonitor);
                bid.setClick_monitors(clickMonitors);
                DpMonitor dpMonitor = bid.getDpMonitor();
                this.dpMonitorWrapper(dpMonitor, buildAttribute);
                bid.setDpMonitor(dpMonitor);
                AppMonitor appMonitor = bid.getApp_monitor();
                this.appMonitorWrapper(appMonitor, buildAttribute);
                bid.setApp_monitor(appMonitor);
                boolean needClickMonitor = this.needClickMonitorByMedia(bidRequest);
                String clickThroughUrl302 = this.buildClickUrl302(bid, buildAttribute, needClickMonitor);
                if (needClickMonitor) {
                    bid.setClick_through_url_302(clickThroughUrl302);
                }
                if (CollectionUtils.isNotEmpty(positions = this.adxProperties.getHeadMonitorPositions()) && positions.contains(positionId = AdxContextFactory.get().getPosition().getPositionId())) {
                    bid.setClick_through_url(clickThroughUrl302);
                }
                if (!CollectionUtils.isNotEmpty(headMonitorMediaIds = this.adxProperties.getHeadMonitorMedia()) || !headMonitorMediaIds.contains(mediaId = bidRequest.getMediaId())) continue;
                bid.setClick_through_url(clickThroughUrl302);
            }
        }
    }

    private void dpMonitorWrapper(DpMonitor dpMonitor, BuildAttribute buildAttribute) {
        if (Objects.nonNull(dpMonitor)) {
            String dpSuccessUrl = this.adxProperties.getOpenLog().create(11, OpenlogConstants.WITHOUT_MACROS_OUT);
            String dpFailUrl = this.adxProperties.getOpenLog().create(12, OpenlogConstants.WITHOUT_MACROS_OUT);
            String dpStartUrl = this.adxProperties.getOpenLog().create(10, OpenlogConstants.WITHOUT_MACROS_OUT);
            List<String> dpSuccessList = dpMonitor.getAwk_success_urls();
            if (Objects.isNull(dpSuccessList)) {
                dpSuccessList = new ArrayList<String>();
            }
            dpSuccessList.add(this.macrosHandler.replaceAll(dpSuccessUrl, buildAttribute));
            List<String> dpFailList = dpMonitor.getAwk_fail_urls();
            if (Objects.isNull(dpFailList)) {
                dpFailList = new ArrayList<String>();
            }
            dpFailList.add(this.macrosHandler.replaceAll(dpFailUrl, buildAttribute));
            List<String> dpStartList = dpMonitor.getAwk_start_urls();
            if (Objects.isNull(dpStartList)) {
                dpStartList = new ArrayList<String>();
            }
            dpStartList.add(this.macrosHandler.replaceAll(dpStartUrl, buildAttribute));
            dpMonitor.setAwk_success_urls(dpSuccessList);
            dpMonitor.setAwk_fail_urls(dpFailList);
            dpMonitor.setAwk_start_urls(dpStartList);
        }
    }

    private void appMonitorWrapper(AppMonitor appMonitor, BuildAttribute buildAttribute) {
        if (Objects.nonNull(appMonitor)) {
            String downloadStart = this.adxProperties.getOpenLog().create(15, OpenlogConstants.WITHOUT_MACROS_OUT);
            String downloadFinish = this.adxProperties.getOpenLog().create(16, OpenlogConstants.WITHOUT_MACROS_OUT);
            String installStart = this.adxProperties.getOpenLog().create(17, OpenlogConstants.WITHOUT_MACROS_OUT);
            String installFinish = this.adxProperties.getOpenLog().create(18, OpenlogConstants.WITHOUT_MACROS_OUT);
            List<String> ds_urls = appMonitor.getDs_urls();
            List<String> df_urls = appMonitor.getDf_urls();
            List<String> sf_urls = appMonitor.getSf_urls();
            List<String> ss_urls = appMonitor.getSs_urls();
            if (Objects.isNull(df_urls)) {
                df_urls = new ArrayList<String>();
            }
            df_urls.add(this.macrosHandler.replaceAll(downloadFinish, buildAttribute));
            if (Objects.isNull(ds_urls)) {
                ds_urls = new ArrayList<String>();
            }
            ds_urls.add(this.macrosHandler.replaceAll(downloadStart, buildAttribute));
            if (Objects.isNull(ss_urls)) {
                ss_urls = new ArrayList<String>();
            }
            ss_urls.add(this.macrosHandler.replaceAll(installStart, buildAttribute));
            if (Objects.isNull(sf_urls)) {
                sf_urls = new ArrayList<String>();
            }
            sf_urls.add(this.macrosHandler.replaceAll(installFinish, buildAttribute));
            appMonitor.setSf_urls(sf_urls);
            appMonitor.setDf_urls(df_urls);
            appMonitor.setSs_urls(ss_urls);
            appMonitor.setDs_urls(ds_urls);
        }
    }

    private String buildClickUrl302(Bid bid, BuildAttribute buildAttribute, boolean needClickMonitor) {
        String url = this.adxProperties.getAdsCounter().getPangu302Url();
        String replacedUrl = this.macrosHandler.replaceAll(url, buildAttribute);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)replacedUrl);
        if (needClickMonitor) {
            builder.replaceQueryParam(C_M_URLS, new Object[]{this.getCmUrls(bid.getClick_monitors())});
        }
        builder.replaceQueryParam(C_T_URL, new Object[]{this.getCtUrl(bid.getClick_through_url())});
        return builder.build().toString();
    }

    private String getCmUrls(List<ClickMonitor> clickMonitors) {
        StringBuilder s = new StringBuilder();
        for (ClickMonitor clickMonitor : clickMonitors) {
            s.append(clickMonitor.getClick_monitor_url()).append(SPLIT_FOR_CMURLS);
        }
        return UrlHelper.urlEncode((String)s.toString());
    }

    private String getCtUrl(String clickThroughUrl) {
        if (StringUtils.isNotBlank((String)clickThroughUrl)) {
            return UrlHelper.urlEncode((String)clickThroughUrl);
        }
        return clickThroughUrl;
    }

    private boolean needClickMonitorByMedia(BidRequest bidRequest) {
        AdxConstants.Media media;
        String mediaId = bidRequest.getMediaId();
        return StringUtils.isNotEmpty((String)mediaId) && AdxConstants.Media.Bes == (media = AdxConstants.Media.of(Integer.parseInt(mediaId)));
    }
}

