/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.openlog.event.internal.Click302Event;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DoClick302EventListener
implements EventListener<Click302Event> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;

    public DoClick302EventListener(AdxProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(Click302Event event) {
        String tagid = event.getTagid();
        String bidid = event.getBidid();
        String reqx = event.getReqx();
        if (StringUtils.isEmpty((CharSequence)tagid) || StringUtils.isEmpty((CharSequence)bidid) || StringUtils.isEmpty((CharSequence)reqx)) {
            return;
        }
        List<String> positions = this.properties.getHeadMonitorPositions();
        if (CollectionUtils.isNotEmpty(positions) && positions.contains(tagid)) {
            String url = this.properties.getOpenLog().create(true, 8, new String[0]);
            url = url.replace("__BID_COMMON_REQUEST_ID__", bidid).replace("__TAGID__", tagid).replace("__X_REQ_W__", reqx);
            this.openLogClient.asyncRequest(url);
        }
    }
}

