/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.PositionSceneTypeEnum;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.init.BidRequestInitializer;
import com.bxm.adx.common.sell.init.InitializerParam;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ImpressionInitializer
implements BidRequestInitializer {
    @Override
    public void accept(BidRequest request, InitializerParam param) {
        if (CollectionUtils.isNotEmpty(request.getImps())) {
            Position position = param.getPosition();
            if (Objects.isNull(position)) {
                return;
            }
            for (Impression impression : request.getImps()) {
                request.setMediaTagId(impression.getTag_id());
                impression.setTag_id(position.getPositionId());
                if (org.springframework.util.StringUtils.isEmpty((Object)impression.getId())) {
                    impression.setId(request.getId());
                }
                if (Objects.isNull(impression.getImp_type())) {
                    impression.setImp_type(position.getPositionType());
                }
                this.initImpressionType(impression, position);
                this.insertOrUpdateImpressionSize(impression, param.getPosition());
            }
        }
    }

    private void initImpressionType(Impression impression, Position position) {
        Integer positionType;
        PositionSceneTypeEnum typeEnum;
        if (Objects.isNull(impression.getType()) && Objects.nonNull((Object)(typeEnum = PositionSceneTypeEnum.get(positionType = position.getPositionType())))) {
            switch (typeEnum) {
                case BOOT: 
                case SCREEN: {
                    impression.setType(AdxConstants.Type.IMAGE.getType());
                    break;
                }
                case VIDEO: 
                case INSPIRE_VIDEO: {
                    impression.setType(AdxConstants.Type.VIDEO.getType());
                    break;
                }
                case INFORMATION_FLOW: {
                    impression.setType(AdxConstants.Type.NATIVE.getType());
                }
            }
        }
    }

    private void insertOrUpdateImpressionSize(Impression imp, Position position) {
        if (Objects.nonNull(imp.getW()) && Objects.nonNull(imp.getH())) {
            return;
        }
        String positionSize = position.getPositionSize();
        if (StringUtils.isBlank((String)positionSize)) {
            return;
        }
        String[] sizeArray = positionSize.split(" ")[0].split("\\*");
        if (sizeArray.length != 2) {
            return;
        }
        if (StringUtils.isNumeric((String)sizeArray[0])) {
            imp.setW(Integer.parseInt(sizeArray[0]));
        }
        if (StringUtils.isNumeric((String)sizeArray[1])) {
            imp.setH(Integer.parseInt(sizeArray[1]));
        }
    }

    public int getOrder() {
        return 0;
    }
}

