/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.utils;

import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncProcessor<T>
implements MeterBinder,
Consumer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncProcessor.class);
    private final ExecutorService executorService;
    private final LinkedBlockingQueue<Runnable> queue;

    public AbstractSyncProcessor(int coreSize, int maximumLength, String threadName, RejectedExecutionHandler rejectedExecutionHandler) {
        this.queue = new LinkedBlockingQueue(maximumLength);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(coreSize, coreSize, 0L, TimeUnit.SECONDS, this.queue, (ThreadFactory)new NamedThreadFactory(threadName), rejectedExecutionHandler);
        this.executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)threadPoolExecutor);
    }

    protected abstract String getGaugeName();

    protected abstract Consumer<T> getConsumer();

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)(this.getGaugeName() + ".queue.blocks"), (Object)0, value -> this.queue.size()).register(registry);
    }

    @Override
    public void accept(T t) {
        Consumer consumer = this.getConsumer();
        if (Objects.isNull(consumer)) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                log.warn("accept: {}", (Object)e.getMessage());
            }
        });
    }
}

