/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.ingetration.feign;

import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.abtest.facade.model.AlgorithmResponse;
import com.bxm.abtest.facade.service.ABtestFacadeService;
import com.bxm.adx.common.ingetration.AbtestServiceIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

@EnableFeignClients(value={"com.bxm.abtest.facade"})
@Configuration
@Profile(value={"!standalone"})
public class FeignAbtestServiceIntegrationImpl
implements AbtestServiceIntegration {
    private static final Logger logger = LoggerFactory.getLogger(AbtestServiceIntegration.class);
    @Autowired
    private ABtestFacadeService aBtestFacadeService;

    @Override
    public String getAlgorithmCode(AlgorithmRequest algorithmRequest) {
        try {
            AlgorithmResponse algorithmResponse = this.aBtestFacadeService.getAlgorithmCode(algorithmRequest);
            if (algorithmResponse != null && !StringUtils.isEmpty((Object)algorithmResponse.getAlgorithmCode())) {
                return algorithmResponse.getAlgorithmCode();
            }
            logger.error(" \u8fd4\u56deAlgorithmCode\u4e3a\u7a7a");
            return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
        }
        catch (Exception e) {
            logger.error(" \u8c03\u7528abtest\u5931\u8d25 {}", (Throwable)e);
            return AlgorithmNameEnum.ALGORITHM_SDK_ASSETS_TWO.getAlgorithmCode();
        }
    }
}

