/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.plugin;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginHolder {
    private static final Logger log = LoggerFactory.getLogger(PluginHolder.class);
    private final PluginBus pluginBus;

    public PluginHolder(PluginBus pluginBus) {
        this.pluginBus = pluginBus;
    }

    public <T> T getService(String name, Class<T> clazz) {
        Plugin plugin = this.pluginBus.lookup(name);
        if (null == plugin) {
            log.warn("Not found Plugin for name: {}", (Object)name);
            return null;
        }
        return (T)plugin.getService(clazz);
    }

    public Map<String, Buyer> getBuyers() {
        HashMap buyers = Maps.newHashMap();
        Iterator plugins = this.pluginBus.getAllPlugins();
        while (plugins.hasNext()) {
            Buyer buyer;
            String name;
            block3: {
                Plugin next = (Plugin)plugins.next();
                name = next.getConfig().getKey();
                buyer = null;
                try {
                    buyer = (Buyer)next.getService(Buyer.class);
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Plugin {} is a entrance plugin", (Object)name);
                }
            }
            if (null == buyer) continue;
            buyers.put(name, buyer);
        }
        return buyers;
    }
}

