/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sdkconfig;

import com.bxm.adx.common.PositionSdkConfigChannelEnum;
import com.bxm.adx.common.sdkconfig.SdkConfig;
import com.bxm.adx.common.sdkconfig.SdkConfigDao;
import com.bxm.adx.common.sdkconfig.SdkConfigService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.adx.facade.model.position.SdkConfigRequest;
import com.bxm.adx.facade.model.position.SdkConfigResponse;
import com.bxm.user.id.generator.DeviceHelper;
import com.bxm.user.id.generator.DeviceInfo;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SdkConfigServiceImpl
implements SdkConfigService {
    private static final Logger log = LoggerFactory.getLogger(SdkConfigServiceImpl.class);
    private final SdkConfigDao sdkConfigDao;
    private final PositionService positionService;

    public SdkConfigServiceImpl(SdkConfigDao sdkConfigDao, PositionService positionService) {
        this.sdkConfigDao = sdkConfigDao;
        this.positionService = positionService;
    }

    @Override
    public List<SdkConfigResponse> getByPositionId(SdkConfigRequest sdkConfigRequest, Position position) {
        boolean result;
        boolean isSupportException = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_EXCEPTION_325.getVersion(), (String)sdkConfigRequest.getSdkv());
        String positionId = sdkConfigRequest.getPositionId();
        if (null == position && null == (position = this.positionService.getByPositionId(positionId))) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\uff1a{} \u7684\u5e7f\u544a\u4f4d\u4fe1\u606f\u3002", (Object)positionId);
            }
            if (isSupportException) {
                throw new AdxException(AdxErrEnum.POSITION_NOT_FOUND);
            }
            return Collections.emptyList();
        }
        if (!position.getPositionScene().equals(sdkConfigRequest.getPositionScene())) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e2d\uff0c\u5e7f\u544a\u4f4d\uff1a{} \u7684\u573a\u666f\u4fe1\u606f\u4e0d\u5339\u914d\u3002", (Object)positionId);
            }
            if (isSupportException) {
                throw new AdxException(AdxErrEnum.POSITION_SCENE_MISMATCH);
            }
            return Collections.emptyList();
        }
        if (isSupportException && !(result = this.positionService.verifyPosition(position, sdkConfigRequest.getAppId(), sdkConfigRequest.getPackageName(), sdkConfigRequest.getSdkv()))) {
            throw new AdxException(AdxErrEnum.APP_INFO_ERR);
        }
        List<SdkConfig> sdkConfigs = this.sdkConfigDao.getByPositionId(positionId);
        sdkConfigs = Boolean.TRUE.equals(sdkConfigRequest.getIsDebug()) ? this.getSdkConfigsForDebug(sdkConfigs) : this.getSdkConfigForDynamic(sdkConfigs, sdkConfigRequest);
        ArrayList<SdkConfigResponse> sdkConfigResponses = new ArrayList<SdkConfigResponse>(sdkConfigs.size());
        for (SdkConfig sdkConfig : sdkConfigs) {
            SdkConfigResponse sdkConfigResponse = new SdkConfigResponse();
            BeanUtils.copyProperties((Object)sdkConfig, (Object)sdkConfigResponse);
            sdkConfigResponses.add(sdkConfigResponse);
        }
        return sdkConfigResponses;
    }

    private List<SdkConfig> getSdkConfigForDynamic(List<SdkConfig> sdkConfigs, SdkConfigRequest sdkConfigRequest) {
        boolean isSupportBxmBackup;
        DeviceInfo info = new DeviceInfo().setImei(sdkConfigRequest.getImei()).setImeiMd5(sdkConfigRequest.getImei_md5()).setOaid(sdkConfigRequest.getOaid()).setAnid(sdkConfigRequest.getAnid()).setAnidMd5(sdkConfigRequest.getAnid_md5()).setIdfa(sdkConfigRequest.getIdfa()).setIdfaMd5(sdkConfigRequest.getIdfa_md5()).setOs(sdkConfigRequest.getOs().intValue());
        String devNo = DeviceHelper.getUid((DeviceInfo)info);
        SdkConfig bxmBackupSdkConfig = null;
        SdkConfig bdSdkConfig = null;
        SdkConfig ksSdkConfig = null;
        SdkConfig adSdkConfig = null;
        boolean isIos = Objects.equals(sdkConfigRequest.getOs(), DevOsEnum.IOS.getId());
        boolean isSupportBdAndKsAndAd = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.IOS_SUPPORT_BD_AND_KS_331.getVersion(), (String)sdkConfigRequest.getSdkv());
        for (SdkConfig conf : sdkConfigs) {
            if (Objects.equals(PositionSdkConfigChannelEnum.BACKUP.getCode(), conf.getChannelType())) {
                bxmBackupSdkConfig = conf;
            }
            if (!isIos || isSupportBdAndKsAndAd) continue;
            if (Objects.equals(PositionSdkConfigChannelEnum.BD.getCode(), conf.getChannelType())) {
                bdSdkConfig = conf;
                continue;
            }
            if (Objects.equals(PositionSdkConfigChannelEnum.KS.getCode(), conf.getChannelType())) {
                ksSdkConfig = conf;
                continue;
            }
            if (!Objects.equals(PositionSdkConfigChannelEnum.AD.getCode(), conf.getChannelType())) continue;
            adSdkConfig = conf;
        }
        if (bxmBackupSdkConfig != null) {
            sdkConfigs.remove(bxmBackupSdkConfig);
        }
        if (bdSdkConfig != null) {
            sdkConfigs.remove(bdSdkConfig);
        }
        if (ksSdkConfig != null) {
            sdkConfigs.remove(ksSdkConfig);
        }
        if (adSdkConfig != null) {
            sdkConfigs.remove(adSdkConfig);
        }
        sdkConfigs.removeIf(p -> p.getRateOfFlow() != null && p.getRateOfFlow() == 0);
        String dmy = DateHelper.format((Date)new Date(), (String)"yyyyMMdd");
        Map<String, Integer> channelTypeAndViewNumMap = this.sdkConfigDao.getByPositionIdDateChannelViewData(sdkConfigRequest.getPositionId(), dmy, devNo);
        boolean needRateFilter = Objects.nonNull(sdkConfigs.stream().filter(p -> p.getRateOfFlow() != null && p.getRateOfFlow() != 100).findFirst().orElse(null));
        if (needRateFilter) {
            this.rateAndFrequencyControlFilter(sdkConfigs, sdkConfigRequest, devNo, dmy, channelTypeAndViewNumMap);
        } else {
            this.frequencyControlFilter(sdkConfigs, sdkConfigRequest, devNo, dmy, channelTypeAndViewNumMap);
        }
        boolean bl = isSupportBxmBackup = StringUtils.isNotBlank((CharSequence)sdkConfigRequest.getSdkv()) && StringHelper.isNewVersion((String)SdkVersionEnum.SUPPORT_BXM_BACKUP_30.getVersion(), (String)sdkConfigRequest.getSdkv());
        if (isSupportBxmBackup && bxmBackupSdkConfig != null) {
            sdkConfigs.add(bxmBackupSdkConfig);
        }
        return sdkConfigs;
    }

    private void rateAndFrequencyControlFilter(List<SdkConfig> sdkConfigs, SdkConfigRequest sdkConfigRequest, String devNo, String dmy, Map<String, Integer> channelTypeAndViewNumMap) {
        Map<String, Integer> testDevMap = this.getTestMobileDev();
        int frequencyControlLoopCount = 0;
        SdkConfig lastSdkConfig = sdkConfigs.get(sdkConfigs.size() - 1);
        int lastSort = lastSdkConfig.getSort();
        for (SdkConfig sdkConfig : sdkConfigs) {
            Integer viewNum;
            if (sdkConfig.getRateOfFlow() != null && sdkConfig.getRateOfFlow() != 100) {
                boolean isTopBxm;
                boolean bl = isTopBxm = Math.abs(devNo.hashCode() % 100) < testDevMap.getOrDefault(devNo, sdkConfig.getRateOfFlow());
                if (isTopBxm) {
                    Integer viewNum2;
                    if (channelTypeAndViewNumMap == null || channelTypeAndViewNumMap.size() <= 0 || (viewNum2 = channelTypeAndViewNumMap.get(PositionSdkConfigChannelEnum.get(sdkConfig.getChannelType()).getDateChannelView())) == null || sdkConfig.getFrequency() == null || viewNum2 < sdkConfig.getFrequency()) continue;
                    sdkConfig.setSort(++lastSort);
                    ++frequencyControlLoopCount;
                    continue;
                }
                sdkConfig.setSort(++lastSort);
                continue;
            }
            if (channelTypeAndViewNumMap == null || channelTypeAndViewNumMap.size() <= 0 || (viewNum = channelTypeAndViewNumMap.get(PositionSdkConfigChannelEnum.get(sdkConfig.getChannelType()).getDateChannelView())) == null || sdkConfig.getFrequency() == null || viewNum < sdkConfig.getFrequency()) continue;
            sdkConfig.setSort(++lastSort);
            ++frequencyControlLoopCount;
        }
        if (frequencyControlLoopCount >= sdkConfigs.size()) {
            this.sdkConfigDao.deletePositionIdDateChannelViewData(sdkConfigRequest.getPositionId(), dmy, devNo);
        }
    }

    private void frequencyControlFilter(List<SdkConfig> sdkConfigs, SdkConfigRequest sdkConfigRequest, String devNo, String dmy, Map<String, Integer> channelTypeAndViewNumMap) {
        if (channelTypeAndViewNumMap != null && channelTypeAndViewNumMap.size() > 0) {
            int frequencyControlLoopCount = 0;
            SdkConfig lastSdkConfig = sdkConfigs.get(sdkConfigs.size() - 1);
            int lastSort = lastSdkConfig.getSort();
            for (SdkConfig sdkConfig : sdkConfigs) {
                Integer viewNum = channelTypeAndViewNumMap.get(PositionSdkConfigChannelEnum.get(sdkConfig.getChannelType()).getDateChannelView());
                if (viewNum == null || sdkConfig.getFrequency() == null || viewNum < sdkConfig.getFrequency()) continue;
                sdkConfig.setSort(++lastSort);
                ++frequencyControlLoopCount;
            }
            if (frequencyControlLoopCount >= sdkConfigs.size()) {
                this.sdkConfigDao.deletePositionIdDateChannelViewData(sdkConfigRequest.getPositionId(), dmy, devNo);
            }
        }
    }

    private Map<String, Integer> getTestMobileDev() {
        HashMap<String, Integer> testDevMap = new HashMap<String, Integer>(2);
        testDevMap.put("FD4AA4C3-8859-4CB4-A9B5-37424FFB4EFC", 100);
        testDevMap.put("868133036330918", 100);
        return testDevMap;
    }

    private List<SdkConfig> getSdkConfigsForDebug(List<SdkConfig> sdkConfigs) {
        if (CollectionUtils.isEmpty(sdkConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<SdkConfig> resps = new ArrayList<SdkConfig>();
        for (SdkConfig conf : sdkConfigs) {
            if (!Objects.equals(PositionSdkConfigChannelEnum.BXM.getCode(), conf.getChannelType())) continue;
            resps.add(conf);
            return resps;
        }
        return resps;
    }
}

