package com.bxm.adx.common;

import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.http.client.config.CookieSpecs;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
@ConfigurationProperties(prefix = "adx")
public class AdxProperties {

    /**
     * 买方竞价超时时间，单位：毫秒。默认：100
     */
    @Deprecated
    private int buyerBiddingTimeOutInMillis = 1000;

    /**
     * 并发买方竞价超时时间，单位：毫秒。默认：200
     */
    @Deprecated
    private int buyerConcurrentBiddingTimeOutInMillis = 200;

    /**
     * 买方请求连接超时时间，单位：毫秒。默认：100
     */
    private int buyerBiddingConnectTimeOutInMillis = 100;

    /**
     * 买方请求读取结果超时时间，单位：毫秒。默认：300
     */
    private int buyerBiddingSocketTimeOutInMillis = 300;

    /**
     * 买方请求连接池 DefaultMaxPerRoute
     */
    private int buyerDefaultMaxPerRoute = 100;

    /**
     * 买方请求连接池 MaxTotal
     */
    private int buyerMaxTotal = 200;

    /**
     * 统计接口地址
     */
    private String counterBaseUrl = "http://count.hzbxm.com/adx/dot/countInfo";

    /**
     * <p>最大买家队列容量，默认 5级。</p>
     * <p>流量分配时，分发优先级数量最不超过这个值。</p>
     */
    private int maxCapacityOfBuyers = 5;

    /**
     * 买方响应 Cookie 策略。
     * 可选值：default、standard、ignoreCookies 等
     *
     * @see CookieSpecs
     */
    private String buyerCookieSpec = "standard";

    /**
     * OpenLog 服务相关配置
     */
    private OpenLogProperties openLog = new OpenLogProperties();

    /**
     * 价格加解密key配置
     */
    private CipherProperties cipherProperties = new CipherProperties();

    /**
     * dsp线程池配置
     */
    private DspThreadPoolProperties dspThreadPool = new DspThreadPoolProperties();

    /**
     * 当开启请求事件或竞价事件监听器时，采样的百分比设置。
     */
    private int dotSimplingPercent = 1;

    /**
     * 百度注册在ssp的媒体bxm-appid
     */
    @Deprecated
    private String besAppId = "8330860c4cca413f8f6e2cd6c06664b5";
    private String besAndroidAppId = "cdb9abe146ba4f7c81a42c4ee3a06a0d";
    private String besIosAppId = "3c455cbc7cc14edb9d353c7d6a9e93e3";
    /**
     * AdsCounter 服务相关配置
     */
    private AdsCounter adsCounter = new AdsCounter();

    /**
     * 落地页head头监控广告位
     */
    private List<String> headMonitorPositions = Lists.newArrayList("804933001028", "808802007001", "808802001001", "808802012001");
    /**
     * 落地页head头监控广告位
     */
    private List<String> headMonitorMedia = Lists.newArrayList(AdxConstants.Media.Qutoutiao.getId() + "", AdxConstants.Media.Zhangyue.getId() + "");

    /**
     * 埋点控制
     */
    private List<DotEventControlProperties>  dotEventControls;


    @Data
    public static class AdsCounter {
        /**
         * 封装落地页302跳转
         */
        private String remoteHost302 = "https://adx-openapi.hzbxm.com";

        /**
         * 封装落地页302跳转url参数
         */
        private String uriParam302 = "/click" +
                "?bidid=" + OpenlogConstants.Macros.BIDID +
                "&tagid=" + OpenlogConstants.Macros.TAGID;

        public String getPangu302Url() {
            return remoteHost302 + uriParam302;
        }
    }

    private String sspDefaultAdapterName;

    private Map<String,SspConfig> sspConfig = new HashMap<>();

    @Data
    public static class SspConfig {

        private String mediaId;

        private Integer encryptionModel;
    }
}
