package com.bxm.adx.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by Arei on 2020/10/9.
 */
@ControllerAdvice
@Slf4j
public class ExceptionAdvice  {

    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

//    @ExceptionHandler(Exception.class)
//    @ResponseBody
//    public ResponseEntity<Object> handleException(Exception ex) {
//        if (log.isDebugEnabled()) {
//            log.debug("catch error = {}", ex.getMessage());
//        }
//        ObjectNode objectNode = objectMapper.createObjectNode();
//        HttpStatus status = HttpStatus.OK;
//
//        if (ex instanceof AdxException) {
//            AdxException adxException = (AdxException) ex;
//            HttpStatus resolve = HttpStatus.resolve(adxException.getCode());
//            if (Objects.nonNull(resolve)) {
//                status = resolve;
//            }
//
//            AdxErrEnum adxErrEnum = adxException.getAdxErrEnum();
//            if (Objects.nonNull(adxErrEnum)) {
//                objectNode.put("result", adxErrEnum.getResult());
//                objectNode.put("msg", adxException.getMessage());
//            }
//        }
//
//        return ResponseEntity.status(status).body(objectNode);
//    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public ResponseEntity<Object> handleException(Exception ex) {
        if (log.isDebugEnabled()) {
            log.debug("catch error = ", ex);
        }

        return ResponseEntity.status(HttpStatus.OK).build();
    }
}
