package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 销售方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BidModelAdapter extends ModelAdapter {
    default AdxConstants.Media media() {
        return AdxConstants.Media.Unknown;
    }

    BidRequest convert(byte[] bytes);

    byte[] convert(BidResponse e, BidRequest bidRequest);

    default Map<String, String>  header(){ return new HashMap<>();}

    /**
     * 不竞价的状态码
     * @return 默认：200
     */
    default int statusCode() {
        return HttpStatus.OK.value();
    }

    /**
     * 如果发生异常或不竞价的情况，有可能接入方有特殊的要求返回的格式，那么可以实现该接口。
     * @param request 请求模型
     * @return 异常或不竞价情况下响应内容字节码。
     * <pre>
     *     比如美团要求不竞价返回：{"code" : 204}
     * </pre>
     */
    default byte[] reject(BidRequest request, AdxErrEnum adxErrEnum) {
        return new byte[0];
    }
    default void customHttpResponse(byte[] data, HttpServletResponse response) { }
}
