package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.domain.DomainService;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.*;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.facade.constant.enums.SdkVersionEnum;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class ConcreteSspResponseBuilder extends SspResponseBuilder {

    private AdxProperties properties;
    private MonitorBuilder monitorBuilder;
    private DomainService domainService;
    private DspService dspService;
    private final IpService ipService;

    public ConcreteSspResponseBuilder(AdxProperties properties,
                                      MonitorBuilder monitorBuilder, DomainService domainService, DspService dspService, IpService ipService) {
        this.properties = properties;
        this.monitorBuilder = monitorBuilder;
        this.domainService = domainService;
        this.dspService = dspService;
        this.ipService = ipService;
    }

    @Override
    public void buildResult(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;

        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "无";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest, SspResponse sspResponse) {
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        AdxCounterParam param = null;
        if (null != bidRequest) {
            Device device = bidRequest.getDevice();
            if (null != device) {
                String os = null;
                String osStr = device.getOs();
                if (!StringUtils.isEmpty(osStr)) {
                    if ("ios".equalsIgnoreCase(osStr)) {
                        os = "2";
                    }
                    if ("android".equalsIgnoreCase(osStr)) {
                        os = "1";
                    }
                }

                Long configId = AdxContextFactory.get().getConfigId();
                param = AdxCounterParam.builder()
                        .anid(device.getDpid())
                        .anid_md5(device.getDpid_md5())
                        .idfa(device.getIdfa())
                        .idfa_md5(device.getIdfa_md5())
                        .imei(device.getImei())
                        .imei_md5(device.getImei_md5())
                        .oaid(device.getOaid())
                        .gaid(device.getGaid())
                        .gaid_md5(device.getGaid_md5())
                        .mac(device.getMac())
                        .os(os)
                        .ip(device.getIp())
                        .ua(device.getUa())//埋点加密自己做了转码
//                            .ua(URLEncoder.encode(device.getUa(), "UTF-8"))
                        .experimentid(configId == null ? "" : configId.toString())
                        .build();
            }
        }
        String url = domainService.replaceCountDomain(bidRequest, properties.getCounterBaseUrl());

        List<com.bxm.adx.common.sell.ssp.resp.Ad> ads = new ArrayList<>(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            Long dspId = seatBid.getDspId();
            Dsp dsp = dspService.get(dspId);
            for (Bid bid : bids) {

                if (param == null) {
                    param = AdxCounterParam.builder().build();
                }

                param.setBidid(e.getId());
                param.setDspid(seatBid.getDspId().toString());
                param.setCreateid(bid.getCreate_id());
                param.setTagid(bid.getTag_id());
                param.setScene(bid.getScene());
                param.setWin(bid.getPrice_str());
                param.setActid(bid.getAct_id());
                param.setStid(bid.getStid() == null ? null : bid.getStid().toString());
                if (Objects.nonNull(dsp)) {
                    Long advId = dsp.getAdvertiser();
                    if (Objects.nonNull(advId)) {
                        param.setAvtsid(advId.toString());
                    }
                }

                com.bxm.adx.common.sell.ssp.resp.Ad ad = new com.bxm.adx.common.sell.ssp.resp.Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric(8));
                ad.setDsp_platform(seatBid.getDsp_platform());
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                ad.setExt(bid.getExt());
                ad.setFail(Fail.of(bid.getFail()));
                ad.setPrice(bid.getPrice());

                DownloadInfo downloadInfo = new DownloadInfo();
                com.bxm.adx.common.sell.response.DownloadInfo di = bid.getDownload_info();
                if (Objects.nonNull(di)) {
                    BeanUtils.copyProperties(di, downloadInfo);
                    ad.setDownload_info(downloadInfo);
                }
//                Position position = positionService.getByPositionId(ad.getPlace_token());
                Position position = AdxContextFactory.get().getPosition();
                if (Objects.nonNull(position)) {
//                    position = positionService.getByPositionId(bidRequest.getBxmTagId());
                    param.setTagid(position.getPositionId());
                    ad.setPlace_token(position.getPositionId());
                }
                if (null != position) {
                    //获取广告位配置
                    Config config = getConfig(position, bidRequest, bid);
                    ad.setConfig(config);

                    //从广告位拿到尺寸信息
                    String positionSize = position.getPositionSize();
                    if (StringUtils.isEmpty(positionSize)) {
                        if (log.isDebugEnabled()) {
                            log.debug("positionSize err");
                        }
                    } else {
                        Map<String, Integer> sizeMap = AdxUtils.getPositionSize(positionSize);
                        if (CollectionUtils.isEmpty(sizeMap)) {
                            if (log.isDebugEnabled()) {
                                log.debug("positionSize analysis err");
                            }
                        } else {
                            Integer w = sizeMap.get("w");
                            Integer h = sizeMap.get("h");
                            param.setW(w == null ? "" : w.toString());
                            param.setH(h == null ? "" : h.toString());
                        }
                    }
                    //获取广告位样式模版
                    if (null != position.getInformationFlowTemplate()) {
                        ad.setTemplate(position.getInformationFlowTemplate());
                    }
                }

                ad.setClick_trackers(monitorBuilder.fillClickMonitor(bid.getClick_monitors(), url, param));

                ad.setImp_trackers(monitorBuilder.fillImpMonitor(bid.getImp_monitors(), url, param));
                if (AdxContextFactory.get().isOptimization()) {
                    if (!CollectionUtils.isEmpty(AdxContextFactory.get().getOptimizationImpUrls())) {
                        ad.getImp_trackers().addAll(AdxContextFactory.get().getOptimizationImpUrls());
                    }
                }
                ad.setFail(monitorBuilder.fillFailMonitor(bid.getFail(), url, param));

                ad.setDeeplink_url(bid.getDeep_link_url());
                if (StringUtils.isNotEmpty(bid.getDeep_link_url())) {
                    ad.setDp_tracker(monitorBuilder.fillDpMonitor(bid.getDpMonitor(), url, param));
                }
                //支持deeplink监测和sdk版本控制
                if (!StringHelper.isNewVersion(SdkVersionEnum.SUPPORT_DEEPLINK_310.getVersion(), bidRequest.getSdk_ver())) {
                    if (null != ad.getDp_tracker()) {
                        List<String> dpSuccessUrls = ad.getDp_tracker().getAwk_success_urls();
                        if (!CollectionUtils.isEmpty(dpSuccessUrls)) {
                            List<String> cts = ad.getClick_trackers();
                            if (!CollectionUtils.isEmpty(cts)) {
                                cts.addAll(dpSuccessUrls);
                            } else {
                                cts = dpSuccessUrls;
                            }
                            ad.setClick_trackers(cts);
                        }
                    }
                }
                if (AdxConstants.Action.isAppDownload(ad.getAction())) {
                    ad.setAppTracker(monitorBuilder.fillAppTracker(bid.getApp_monitor(), url, param));
                }
                ad.setTarget_url(bid.getClick_through_url());

                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                //素材
                com.bxm.adx.common.sell.ssp.resp.Native an = new com.bxm.adx.common.sell.ssp.resp.Native();
                List<com.bxm.adx.common.sell.ssp.resp.Asset> assets = new ArrayList<>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                an.setTemplate(sn.getTemplate());
                List<com.bxm.adx.common.sell.response.Asset> snAssets = sn.getAssets();
                for (com.bxm.adx.common.sell.response.Asset sa : snAssets) {
                    com.bxm.adx.common.sell.ssp.resp.Asset asset = new com.bxm.adx.common.sell.ssp.resp.Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    AdxConstants.AssetType assetType = AdxConstants.AssetType.getAssetType(sa.getType());
                    if (assetType == AdxConstants.AssetType.UNKNOW) {
                        if (log.isWarnEnabled()) {
                            log.warn("posId = {}, asset = {}", position.getPositionId(), assetType.name());
                        }
                    }
                    switch (assetType) {
                        case TITLE:
                            com.bxm.adx.common.sell.ssp.resp.Text title = new com.bxm.adx.common.sell.ssp.resp.Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        case CONTENT:
                            com.bxm.adx.common.sell.ssp.resp.Text content = new com.bxm.adx.common.sell.ssp.resp.Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        case BTN_TEXT:
                            com.bxm.adx.common.sell.ssp.resp.Text buttonText = new com.bxm.adx.common.sell.ssp.resp.Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        case ICON:
                            com.bxm.adx.common.sell.ssp.resp.Image image = new com.bxm.adx.common.sell.ssp.resp.Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            image.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(image);
                            break;
                        case LARGE_IMG:
                            com.bxm.adx.common.sell.ssp.resp.Image limg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            limg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(limg);
                            break;
                        case BTN_IMG:
                            com.bxm.adx.common.sell.ssp.resp.Image bimg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            bimg.setAnimation_style(sa.getImg().getAnimation_style());
                            asset.setImg(bimg);
                            break;
                        case REWARDER_VIDEO:
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            com.bxm.adx.common.sell.response.Video v = sa.getVideo();
                            BeanUtils.copyProperties(v, video);

                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties(v.getV_monitor(), vm);
                            }
                            Integer duration = video.getDuration();
                            if (null != duration) {
                                param.setVi_duration((duration / 1000) + "");
                            }
                            video.setV_monitor(monitorBuilder.fillVMonitor(vm, url, param));
                            asset.setVideo(video);
                            break;
                        case POPUP_ASSET_INFO:
                            com.bxm.adx.common.sell.ssp.resp.Text popupInfo = new com.bxm.adx.common.sell.ssp.resp.Text();
                            popupInfo.setText(sa.getText().getText());
                            asset.setText(popupInfo);
                            break;
                        case POPUP_WEB_URL:
                            com.bxm.adx.common.sell.ssp.resp.Text popupWebUrl = new com.bxm.adx.common.sell.ssp.resp.Text();
                            popupWebUrl.setText(sa.getText().getText());
                            asset.setText(popupWebUrl);
                            break;
                        default:
                            if (log.isWarnEnabled()) {
                                log.warn("posId = {}, asset = {}", position.getPositionId(), assetType.name());
                            }
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);

                ads.add(ad);
            }
        }
        ads = ads.stream()
                .sorted(Comparator.comparing(Ad::getPrice).reversed())
                .collect(Collectors.toList());
        sspResponse.setAds(ads);
        sspResponse.setResult(AdxConstants.RESULT_OK);
    }

    /**
     * 开屏插屏广告位配置
     */
    private void bootConfig(Config config, PositionJsonConfig positionJsonConfig, BidRequest bidRequest) {
        String region = null;
        if (Objects.nonNull(positionJsonConfig)) {
            PositionJsonConfig.Boot boot = positionJsonConfig.getBoot();
            if (Objects.nonNull(boot)) {
                region = boot.getRegion();
                config.setBoot_ae_btn(boot.getFirstUsingAeButton());
                config.setKeenConfig(Objects.nonNull(boot.getKeenConfig()) ?  boot.getKeenConfig() : 50);
            }
        }

        //以上都在解析获取最后全屏点击地域配置
        config.setBoot_full_screen_click(getBootFullScreenClick(region, bidRequest));
    }

    /**
     * 插屏广告位配置
     */
    private void screenConfig(Config config, PositionJsonConfig positionJsonConfig) {
        if (Objects.nonNull(positionJsonConfig)) {
            PositionJsonConfig.Screen screen = positionJsonConfig.getScreen();
            if (Objects.nonNull(screen)) {
                config.setScreen_load_duration(screen.getMaxLoadingTime());
            }
        }
    }

    /**
     * 开屏广告位解析地域控制全屏点击
     *
     * @param region
     * @return
     */
    private Integer getBootFullScreenClick(String region, BidRequest bidRequest) {
        if (StringUtils.isNotEmpty(region)) {
            IP ip = AdxContextFactory.get().getIp();
            if (Objects.isNull(ip)) {
                String ipStr = null;
                if (Objects.nonNull(bidRequest)) {
                    Device device = bidRequest.getDevice();
                    if (Objects.nonNull(device)) {
                        ipStr = device.getIp();
                        ip = ipService.analyze(ipStr);
                    }
                }
            }
            List<String> rs = Arrays.asList(region.split(","));
            Set<String> set = Sets.newHashSet();
            Boolean isWhite = null;
            for (String r : rs) {
                String[] rule = r.split("-");
                if (rule.length == 2 && Objects.isNull(isWhite)) {
                    if (rule[0].equals("1")) {
                        isWhite = true;
                    } else {
                        isWhite = false;
                    }
                    set.add(rule[1]);
                } else {
                    set.add(rule[0]);
                }
            }

            boolean isMatch = ip.in(set);
            if (isMatch) {
                if (isWhite) {
                    return 1;
                } else {
                    return 0;
                }
            } else {
                if (isWhite) {
                    return 0;
                } else {
                    return 1;
                }
            }
        } else {
            return 0;
        }
    }

    /**
     * 获取广告位配置
     *
     * @param position
     * @param bidRequest
     * @param bid
     * @return
     */
    private Config getConfig(Position position, BidRequest bidRequest, Bid bid) {
        //获取广告位配置
        Config config = new Config();
        config.setBoot_time(position.getBootTime());
        config.setClick_video_action(position.getClickVideoAction());
        config.setShow_ad_logo(position.getIsShowAdLogo());
        config.setShow_endpage(position.getIsShowEndpage());
        config.setRefreshInterval_time(position.getRefreshIntervalTime());
        config.setRefresh_model(position.getRefreshModel());
        config.setIsShowActivityCloseButton(position.getIsShowActivityCloseButton());
        config.setShowSkipButton(position.getShowSkipButton());
        config.setDownloadPopSwitch(Objects.nonNull(position.getDownloadPopSwitch()) ? position.getDownloadPopSwitch() : 0);
        config.setDownloadBarStyle(Objects.nonNull(position.getDownloadBarStyle()) ?  position.getDownloadBarStyle() : 2);
        config.setHttpHeaderSwitch(1);

        boolean isNewVersion = StringHelper.isNewVersion(SdkVersionEnum.SUPPORT_PRELOADING_351.getVersion(), bidRequest.getSdk_ver());
        if (isNewVersion) {
            config.setOpen_preloading(position.getOpenPreloading() == null ? 0 : position.getOpenPreloading());
        } else {
            config.setOpen_preloading(0);
        }
        config.setShow_title_bar(bid.getShow_title_bar() == null ? 1 : bid.getShow_title_bar());
        PositionJsonConfig positionJsonConfig = getPositionJsonConfig(position);
        Byte pScene = position.getPositionScene();
        if (pScene == null) {
            config.setBoot_full_screen_click(0);
        }
        PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get(pScene.intValue());
        switch (typeEnum) {
            case BOOT:
                bootConfig(config, positionJsonConfig, bidRequest);
                config.setDownloadPopSwitch(Objects.nonNull(position.getDownloadPopSwitch()) ? position.getDownloadPopSwitch() : 1);
                config.setDownloadBarStyle(Objects.nonNull(position.getDownloadBarStyle()) ?  position.getDownloadBarStyle() : 0);
                break;
            case TEXT_LINK:
                textLinkConfig(config, positionJsonConfig);
                if (StringUtils.isEmpty(position.getPictureConstraints())) {
                    bid.setType(AdxConstants.Type.TEXT.getType());
                }
                break;
            case SCREEN:
                screenConfig(config, positionJsonConfig);
                break;
        }
        return config;
    }

    /**
     * 获取PositionJsonConfig
     *
     * @param position
     * @return
     */
    private PositionJsonConfig getPositionJsonConfig(Position position) {
        String jsonConfig = position.getJsonConfig();
        if (StringUtils.isNotEmpty(jsonConfig)) {
            PositionJsonConfig positionJsonConfig = AdxUtils.getJsonConfig(jsonConfig);
            return positionJsonConfig;
        }
        return null;
    }

    /**
     * 文字链广告位配置
     * @param config
     * @param positionJsonConfig
     */
    private void textLinkConfig(Config config, PositionJsonConfig positionJsonConfig) {
        Integer adLogo = null;
        if (Objects.nonNull(positionJsonConfig)) {
            PositionJsonConfig.TextLink textLink = positionJsonConfig.getTextLink();
            if (Objects.nonNull(textLink)) {
                adLogo = textLink.getAdLogo();
            }
        }
        if (Objects.isNull(adLogo)) {
            adLogo = 0;
        }
        config.setAd_logo(adLogo);
    }
}
